/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.jbi.JBIException;
import javax.jbi.management.LifeCycleMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.servicemix.jbi.management.OperationInfoHelper;

public abstract class BaseLifeCycle
implements LifeCycleMBean,
MBeanInfoProvider {
    public static final String INITIALIZED = "Initialized";
    protected String currentState = "Unknown";
    protected PropertyChangeListener listener;

    public String getName() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public String getType() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public String getSubType() {
        return null;
    }

    protected void init() throws JBIException {
        this.setCurrentState(INITIALIZED);
    }

    public void start() throws JBIException {
        this.setCurrentState("Started");
    }

    public void stop() throws JBIException {
        this.setCurrentState("Stopped");
    }

    public void shutDown() throws JBIException {
        this.setCurrentState("Shutdown");
    }

    public String getCurrentState() {
        return this.currentState;
    }

    protected void setCurrentState(String newValue) {
        String oldValue = this.currentState;
        this.currentState = newValue;
        this.firePropertyChanged("currentState", oldValue, newValue);
    }

    public boolean isStarted() {
        return this.currentState != null && this.currentState.equals("Started");
    }

    public boolean isStopped() {
        return this.currentState != null && this.currentState.equals("Stopped");
    }

    public boolean isShutDown() {
        return this.currentState != null && this.currentState.equals("Shutdown");
    }

    public boolean isInitialized() {
        return this.currentState != null && this.currentState.equals(INITIALIZED);
    }

    public boolean isUnknown() {
        return this.currentState == null || this.currentState.equals("Unknown");
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "currentState", "Current State of Managed Item");
        helper.addAttribute(this.getObjectToManage(), "name", "name of the Item");
        helper.addAttribute(this.getObjectToManage(), "description", "description of the Item");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "start", "start the item");
        helper.addOperation(this.getObjectToManage(), "stop", "stop the item");
        helper.addOperation(this.getObjectToManage(), "shutDown", "shutdown the item");
        return helper.getOperationInfos();
    }

    public Object getObjectToManage() {
        return this;
    }

    public void setPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    protected void firePropertyChanged(String name, Object oldValue, Object newValue) {
        PropertyChangeListener l = this.listener;
        if (l != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
            l.propertyChange(event);
        }
    }
}

