/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.container.ServiceAssemblyEnvironment;
import org.apache.servicemix.jbi.container.SubscriptionSpec;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.ComponentRegistry;
import org.apache.servicemix.jbi.framework.Endpoint;
import org.apache.servicemix.jbi.framework.EndpointRegistry;
import org.apache.servicemix.jbi.framework.RegistryMBean;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceAssemblyRegistry;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceUnitMBean;
import org.apache.servicemix.jbi.framework.SharedLibrary;
import org.apache.servicemix.jbi.framework.SharedLibraryMBean;
import org.apache.servicemix.jbi.framework.SubscriptionRegistry;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.messaging.DeliveryChannelImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.DynamicEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry
extends BaseSystemService
implements RegistryMBean {
    private static final Log LOG = LogFactory.getLog(Registry.class);
    private ComponentRegistry componentRegistry = new ComponentRegistry(this);
    private EndpointRegistry endpointRegistry = new EndpointRegistry(this);
    private SubscriptionRegistry subscriptionRegistry = new SubscriptionRegistry(this);
    private ServiceAssemblyRegistry serviceAssemblyRegistry = new ServiceAssemblyRegistry(this);
    private Map<String, SharedLibrary> sharedLibraries;
    private Map<String, ServiceUnitLifeCycle> serviceUnits = new ConcurrentHashMap<String, ServiceUnitLifeCycle>();
    private List<ServiceAssemblyLifeCycle> pendingAssemblies = new CopyOnWriteArrayList<ServiceAssemblyLifeCycle>();
    private List<ComponentMBeanImpl> pendingComponents;
    private Executor executor;

    public Registry() {
        this.sharedLibraries = new ConcurrentHashMap<String, SharedLibrary>();
        this.pendingComponents = new CopyOnWriteArrayList<ComponentMBeanImpl>();
    }

    @Override
    public String getDescription() {
        return "Registry of Components/SU's and Endpoints";
    }

    @Override
    protected Class getServiceMBean() {
        return RegistryMBean.class;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    @Override
    public void init(JBIContainer container) throws JBIException {
        super.init(container);
        this.executor = container.getExecutorFactory().createExecutor("services.registry");
    }

    @Override
    public void start() throws JBIException {
        this.componentRegistry.start();
        this.serviceAssemblyRegistry.start();
        super.start();
    }

    @Override
    public void stop() throws JBIException {
        this.serviceAssemblyRegistry.stop();
        this.componentRegistry.stop();
        super.stop();
    }

    @Override
    public void shutDown() throws JBIException {
        this.serviceAssemblyRegistry.shutDown();
        this.componentRegistry.shutDown();
        super.shutDown();
        this.container.getManagementContext().unregisterMBean(this);
        this.executor.shutdown();
    }

    protected EnvironmentContext getEnvironmentContext() {
        return this.container.getEnvironmentContext();
    }

    protected boolean isContainerEmbedded() {
        return this.container.isEmbedded();
    }

    protected InternalEndpoint matchEndpointByName(ServiceEndpoint[] endpoints, String endpointName) {
        InternalEndpoint result = null;
        if (endpoints != null && endpointName != null && endpointName.length() > 0) {
            for (int i = 0; i < endpoints.length; ++i) {
                if (!endpoints[i].getEndpointName().equals(endpointName)) continue;
                result = (InternalEndpoint)endpoints[i];
                break;
            }
        }
        return result;
    }

    public ServiceEndpoint activateEndpoint(ComponentContextImpl context, QName serviceName, String endpointName) throws JBIException {
        return this.endpointRegistry.registerInternalEndpoint(context, serviceName, endpointName);
    }

    public ServiceEndpoint[] getEndpointsForComponent(ComponentNameSpace cns) {
        return this.endpointRegistry.getEndpointsForComponent(cns);
    }

    public ServiceEndpoint[] getEndpointsForInterface(QName interfaceName) {
        return this.endpointRegistry.getEndpointsForInterface(interfaceName);
    }

    public void deactivateEndpoint(ComponentContext provider, InternalEndpoint serviceEndpoint) {
        this.endpointRegistry.unregisterInternalEndpoint(provider, serviceEndpoint);
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        if (!(endpoint instanceof AbstractServiceEndpoint)) {
            throw new JBIException("Descriptors can not be queried for external endpoints");
        }
        AbstractServiceEndpoint se = (AbstractServiceEndpoint)endpoint;
        ComponentMBeanImpl component = this.getComponent(se.getComponentNameSpace());
        return component.getComponent().getServiceDescription(endpoint);
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        for (ComponentMBeanImpl connector : this.getComponents()) {
            ServiceEndpoint se = connector.getComponent().resolveEndpointReference(epr);
            if (se == null) continue;
            return new DynamicEndpoint(connector.getComponentNameSpace(), se, epr);
        }
        ServiceEndpoint se = this.resolveInternalEPR(epr);
        if (se != null) {
            return se;
        }
        return this.resolveStandardEPR(epr);
    }

    public ServiceEndpoint resolveInternalEPR(DocumentFragment epr) {
        if (epr == null) {
            throw new NullPointerException("resolveInternalEPR(epr) called with null epr.");
        }
        NodeList nl = epr.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (el = (Element)n).getNamespaceURI() == null || !el.getNamespaceURI().equals("http://java.sun.com/jbi/end-point-reference") || el.getLocalName() == null || !el.getLocalName().equals("end-point-reference")) continue;
            String serviceName = el.getAttributeNS(el.getNamespaceURI(), "service-name");
            QName serviceQName = DOMUtil.createQName(el, serviceName);
            String endpointName = el.getAttributeNS(el.getNamespaceURI(), "end-point-name");
            return this.getInternalEndpoint(serviceQName, endpointName);
        }
        return null;
    }

    public ServiceEndpoint resolveStandardEPR(DocumentFragment epr) {
        try {
            NodeList children = epr.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                Element elem = (Element)n;
                String[] namespaces = new String[]{"http://www.w3.org/2005/08/addressing", "http://schemas.xmlsoap.org/ws/2004/08/addressing", "http://schemas.xmlsoap.org/ws/2004/03/addressing", "http://schemas.xmlsoap.org/ws/2003/03/addressing"};
                NodeList nl = null;
                for (int ns = 0; ns < namespaces.length; ++ns) {
                    NodeList tnl = elem.getElementsByTagNameNS(namespaces[ns], "Address");
                    if (tnl.getLength() != 1) continue;
                    nl = tnl;
                    break;
                }
                if (nl == null) continue;
                Element address = (Element)nl.item(0);
                String uri = DOMUtil.getElementText(address);
                if (uri != null) {
                    uri = uri.trim();
                }
                if (uri.startsWith("endpoint:")) {
                    uri = uri.substring("endpoint:".length());
                    String[] parts = URIResolver.split3(uri);
                    return this.getInternalEndpoint(new QName(parts[0], parts[1]), parts[2]);
                }
                if (!uri.startsWith("service:")) continue;
                uri = uri.substring("service:".length());
                String[] parts = URIResolver.split2(uri);
                return this.getEndpoint(new QName(parts[0], parts[1]), parts[1]);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Unable to resolve EPR: " + e));
        }
        return null;
    }

    public void registerExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) throws JBIException {
        if (externalEndpoint != null) {
            this.endpointRegistry.registerExternalEndpoint(cns, externalEndpoint);
        }
    }

    public void deregisterExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) {
        this.endpointRegistry.unregisterExternalEndpoint(cns, externalEndpoint);
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        return this.endpointRegistry.getEndpoint(service, name);
    }

    public ServiceEndpoint getInternalEndpoint(QName service, String name) {
        return this.endpointRegistry.getInternalEndpoint(service, name);
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        return this.endpointRegistry.getEndpointsForService(serviceName);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return this.endpointRegistry.getExternalEndpointsForInterface(interfaceName);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return this.endpointRegistry.getExternalEndpointsForService(serviceName);
    }

    public ComponentMBeanImpl registerComponent(ComponentNameSpace name, String description, Component component, boolean binding, boolean service, String[] sharedLibs) throws JBIException {
        return this.componentRegistry.registerComponent(name, description, component, binding, service, sharedLibs);
    }

    public void deregisterComponent(ComponentMBeanImpl component) {
        this.componentRegistry.deregisterComponent(component);
    }

    public Collection<ComponentMBeanImpl> getComponents() {
        return this.componentRegistry.getComponents();
    }

    public ComponentMBeanImpl getComponent(ComponentNameSpace cns) {
        return this.componentRegistry.getComponent(cns);
    }

    public ComponentMBeanImpl getComponent(String name) {
        ComponentNameSpace cns = new ComponentNameSpace(this.container.getName(), name);
        return this.getComponent(cns);
    }

    public ObjectName[] getEngineComponents() {
        ObjectName[] result = null;
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (ComponentMBeanImpl lcc : this.getComponents()) {
            if (lcc.isPojo() || !lcc.isService() || lcc.getMBeanName() == null) continue;
            tmpList.add(lcc.getMBeanName());
        }
        result = new ObjectName[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public ObjectName[] getBindingComponents() {
        ObjectName[] result = null;
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (ComponentMBeanImpl lcc : this.getComponents()) {
            if (lcc.isPojo() || !lcc.isBinding() || lcc.getMBeanName() == null) continue;
            tmpList.add(lcc.getMBeanName());
        }
        result = new ObjectName[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public ObjectName[] getPojoComponents() {
        ObjectName[] result = null;
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (ComponentMBeanImpl lcc : this.getComponents()) {
            if (!lcc.isPojo() || lcc.getMBeanName() == null) continue;
            tmpList.add(lcc.getMBeanName());
        }
        result = new ObjectName[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public void registerSubscriptions(ComponentContextImpl context, ActivationSpec as) {
        QName service = as.getService();
        String endpointName = as.getEndpoint();
        InternalEndpoint endpoint = new InternalEndpoint(context.getComponentNameSpace(), endpointName, service);
        SubscriptionSpec[] specs = as.getSubscriptions();
        if (specs != null) {
            for (int i = 0; i < specs.length; ++i) {
                this.registerSubscription(context, specs[i], endpoint);
            }
        }
    }

    public void deregisterSubscriptions(ComponentContextImpl context, ActivationSpec as) {
        SubscriptionSpec[] specs = as.getSubscriptions();
        if (specs != null) {
            for (int i = 0; i < specs.length; ++i) {
                this.deregisterSubscription(context, specs[i]);
            }
        }
    }

    public void registerSubscription(ComponentContextImpl context, SubscriptionSpec subscription, ServiceEndpoint endpoint) {
        InternalEndpoint sei = (InternalEndpoint)endpoint;
        subscription.setName(context.getComponentNameSpace());
        this.subscriptionRegistry.registerSubscription(subscription, sei);
    }

    public InternalEndpoint deregisterSubscription(ComponentContextImpl context, SubscriptionSpec subscription) {
        subscription.setName(context.getComponentNameSpace());
        return this.subscriptionRegistry.deregisterSubscription(subscription);
    }

    public List<InternalEndpoint> getMatchingSubscriptionEndpoints(MessageExchangeImpl exchange) {
        return this.subscriptionRegistry.getMatchingSubscriptionEndpoints(exchange);
    }

    public ServiceAssemblyLifeCycle registerServiceAssembly(ServiceAssembly sa, ServiceAssemblyEnvironment env) throws DeploymentException {
        return this.serviceAssemblyRegistry.register(sa, env);
    }

    public ServiceAssemblyLifeCycle registerServiceAssembly(ServiceAssembly sa, String[] suKeys, ServiceAssemblyEnvironment env) throws DeploymentException {
        return this.serviceAssemblyRegistry.register(sa, suKeys, env);
    }

    public boolean unregisterServiceAssembly(String saName) {
        return this.serviceAssemblyRegistry.unregister(saName);
    }

    public ServiceAssemblyLifeCycle getServiceAssembly(String saName) {
        return this.serviceAssemblyRegistry.getServiceAssembly(saName);
    }

    public ServiceUnitLifeCycle[] getDeployedServiceUnits(String componentName) {
        ArrayList<ServiceUnitLifeCycle> tmpList = new ArrayList<ServiceUnitLifeCycle>();
        for (ServiceUnitLifeCycle su : this.serviceUnits.values()) {
            if (!su.getComponentName().equals(componentName)) continue;
            tmpList.add(su);
        }
        ServiceUnitLifeCycle[] result = new ServiceUnitLifeCycle[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public Collection<ServiceUnitLifeCycle> getServiceUnits() {
        return this.serviceUnits.values();
    }

    public Collection<ServiceAssemblyLifeCycle> getServiceAssemblies() {
        return this.serviceAssemblyRegistry.getServiceAssemblies();
    }

    public String[] getDeployedServiceAssemblies() {
        return this.serviceAssemblyRegistry.getDeployedServiceAssemblies();
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) {
        return this.serviceAssemblyRegistry.getDeployedServiceAssembliesForComponent(componentName);
    }

    public String[] getComponentsForDeployedServiceAssembly(String saName) {
        return this.serviceAssemblyRegistry.getComponentsForDeployedServiceAssembly(saName);
    }

    public boolean isSADeployedServiceUnit(String componentName, String suName) {
        return this.serviceAssemblyRegistry.isDeployedServiceUnit(componentName, suName);
    }

    public ServiceUnitLifeCycle getServiceUnit(String suKey) {
        return this.serviceUnits.get(suKey);
    }

    public String registerServiceUnit(ServiceUnit su, String saName, File suDir) {
        ServiceUnitLifeCycle sulc = new ServiceUnitLifeCycle(su, saName, this, suDir);
        this.serviceUnits.put(sulc.getKey(), sulc);
        try {
            ObjectName objectName = this.getContainer().getManagementContext().createObjectName(sulc);
            this.getContainer().getManagementContext().registerMBean(objectName, sulc, ServiceUnitMBean.class);
        }
        catch (JMException e) {
            LOG.error((Object)"Could not register MBean for service unit", (Throwable)e);
        }
        return sulc.getKey();
    }

    public void unregisterServiceUnit(String suKey) {
        ServiceUnitLifeCycle sulc = this.serviceUnits.remove(suKey);
        if (sulc != null) {
            try {
                this.getContainer().getManagementContext().unregisterMBean(sulc);
            }
            catch (JBIException e) {
                LOG.error((Object)"Could not unregister MBean for service unit", (Throwable)e);
            }
        }
    }

    public void registerSharedLibrary(org.apache.servicemix.jbi.deployment.SharedLibrary sl, File installationDir) {
        SharedLibrary library = new SharedLibrary(sl, installationDir);
        this.sharedLibraries.put(library.getName(), library);
        try {
            ObjectName objectName = this.getContainer().getManagementContext().createObjectName(library);
            this.getContainer().getManagementContext().registerMBean(objectName, library, SharedLibraryMBean.class);
        }
        catch (JMException e) {
            LOG.error((Object)"Could not register MBean for service unit", (Throwable)e);
        }
        this.checkPendingComponents();
    }

    public void unregisterSharedLibrary(String name) {
        SharedLibrary sl = this.sharedLibraries.remove(name);
        if (sl != null) {
            try {
                this.getContainer().getManagementContext().unregisterMBean(sl);
                sl.dispose();
            }
            catch (JBIException e) {
                LOG.error((Object)"Could not unregister MBean for shared library", (Throwable)e);
            }
        }
    }

    public SharedLibrary getSharedLibrary(String name) {
        return this.sharedLibraries.get(name);
    }

    public Collection<SharedLibrary> getSharedLibraries() {
        return this.sharedLibraries.values();
    }

    public void registerEndpointConnection(QName fromSvc, String fromEp, QName toSvc, String toEp, String link) throws JBIException {
        this.endpointRegistry.registerEndpointConnection(fromSvc, fromEp, toSvc, toEp, link);
    }

    public void unregisterEndpointConnection(QName fromSvc, String fromEp) {
        this.endpointRegistry.unregisterEndpointConnection(fromSvc, fromEp);
    }

    public void registerInterfaceConnection(QName fromItf, QName toSvc, String toEp) throws JBIException {
        this.endpointRegistry.registerInterfaceConnection(fromItf, toSvc, toEp);
    }

    public void unregisterInterfaceConnection(QName fromItf) {
        this.endpointRegistry.unregisterInterfaceConnection(fromItf);
    }

    public void registerRemoteEndpoint(ServiceEndpoint endpoint) {
        this.endpointRegistry.registerRemoteEndpoint((InternalEndpoint)endpoint);
    }

    public void unregisterRemoteEndpoint(ServiceEndpoint endpoint) {
        this.endpointRegistry.unregisterRemoteEndpoint((InternalEndpoint)endpoint);
    }

    public void checkPendingAssemblies() {
        this.executor.execute(new Runnable(){

            public void run() {
                Registry.this.startPendingAssemblies();
            }
        });
    }

    public void addPendingAssembly(ServiceAssemblyLifeCycle sa) {
        if (!this.pendingAssemblies.contains(sa)) {
            this.pendingAssemblies.add(sa);
        }
    }

    protected synchronized void startPendingAssemblies() {
        for (ServiceAssemblyLifeCycle sa : this.pendingAssemblies) {
            ServiceUnitLifeCycle[] sus = sa.getDeployedSUs();
            boolean ok = true;
            for (int i = 0; i < sus.length; ++i) {
                ComponentMBeanImpl c = this.getComponent(sus[i].getComponentName());
                if (c != null && c.isStarted()) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            try {
                sa.restore();
                this.pendingAssemblies.remove(sa);
            }
            catch (Exception e) {
                LOG.error((Object)"Error trying to restore service assembly state", (Throwable)e);
            }
        }
    }

    public void checkPendingComponents() {
        this.executor.execute(new Runnable(){

            public void run() {
                Registry.this.startPendingComponents();
            }
        });
    }

    public void addPendingComponent(ComponentMBeanImpl comp) {
        if (!this.pendingComponents.contains(comp)) {
            this.pendingComponents.add(comp);
        }
    }

    protected synchronized void startPendingComponents() {
        for (ComponentMBeanImpl componentMBeanImpl : this.pendingComponents) {
        }
    }

    @Override
    public ObjectName[] getComponentNames() {
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (ComponentMBeanImpl lcc : this.getComponents()) {
            tmpList.add(this.container.getManagementContext().createObjectName(lcc));
        }
        return tmpList.toArray(new ObjectName[tmpList.size()]);
    }

    @Override
    public ObjectName[] getEndpointNames() {
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (Endpoint ep : this.container.getRegistry().getEndpointRegistry().getEndpointMBeans()) {
            tmpList.add(this.container.getManagementContext().createObjectName(ep));
        }
        return tmpList.toArray(new ObjectName[tmpList.size()]);
    }

    @Override
    public ObjectName[] getServiceAssemblyNames() {
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (ServiceAssemblyLifeCycle sa : this.getServiceAssemblies()) {
            tmpList.add(this.container.getManagementContext().createObjectName(sa));
        }
        return tmpList.toArray(new ObjectName[tmpList.size()]);
    }

    @Override
    public ObjectName[] getServiceUnitNames() {
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (ServiceUnitLifeCycle su : this.serviceUnits.values()) {
            tmpList.add(this.container.getManagementContext().createObjectName(su));
        }
        return tmpList.toArray(new ObjectName[tmpList.size()]);
    }

    @Override
    public ObjectName[] getSharedLibraryNames() {
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        for (SharedLibrary sl : this.sharedLibraries.values()) {
            tmpList.add(this.container.getManagementContext().createObjectName(sl));
        }
        return tmpList.toArray(new ObjectName[tmpList.size()]);
    }

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "componentNames", "list of components");
        helper.addAttribute(this.getObjectToManage(), "serviceUnitNames", "list of service units");
        helper.addAttribute(this.getObjectToManage(), "serviceAssemblyNames", "list of service assemblies");
        helper.addAttribute(this.getObjectToManage(), "endpointNames", "list of endpoints");
        helper.addAttribute(this.getObjectToManage(), "sharedLibraryNames", "list of shared libraries");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    public void cancelPendingExchanges() {
        for (ComponentMBeanImpl mbean : this.componentRegistry.getComponents()) {
            DeliveryChannelImpl channel = mbean.getDeliveryChannel();
            if (channel == null) continue;
            channel.cancelPendingExchanges();
        }
    }
}

