/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployment;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployment.ClassPath;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.deployment.Connection;
import org.apache.servicemix.jbi.deployment.Connections;
import org.apache.servicemix.jbi.deployment.Consumer;
import org.apache.servicemix.jbi.deployment.Consumes;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.Identification;
import org.apache.servicemix.jbi.deployment.InstallationDescriptorExtension;
import org.apache.servicemix.jbi.deployment.Provider;
import org.apache.servicemix.jbi.deployment.Provides;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.deployment.Services;
import org.apache.servicemix.jbi.deployment.SharedLibrary;
import org.apache.servicemix.jbi.deployment.SharedLibraryList;
import org.apache.servicemix.jbi.deployment.Target;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.jbi.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DescriptorFactory {
    public static final String DESCRIPTOR_FILE = "META-INF/jbi.xml";
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private static final Log LOG = LogFactory.getLog(DescriptorFactory.class);

    private DescriptorFactory() {
    }

    public static Descriptor buildDescriptor(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                return DescriptorFactory.buildDescriptor(descriptorFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("There is a bug here...", e);
            }
        }
        return null;
    }

    public static Descriptor buildDescriptor(final URL url) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtil.copyInputStream(url.openStream(), baos);
            SchemaFactory schemaFactory = SchemaFactory.newInstance(XSD_SCHEMA_LANGUAGE);
            Schema schema = schemaFactory.newSchema(DescriptorFactory.class.getResource("/jbi-descriptor.xsd"));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                    LOG.debug((Object)("Validation warning on " + url + ": " + exception));
                }

                public void error(SAXParseException exception) throws SAXException {
                    LOG.info((Object)("Validation error on " + url + ": " + exception));
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            validator.validate(new StreamSource(new ByteArrayInputStream(baos.toByteArray())));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
            Element jbi = doc.getDocumentElement();
            Descriptor desc = new Descriptor();
            desc.setVersion(Double.parseDouble(DescriptorFactory.getAttribute(jbi, "version")));
            Element child = DOMUtil.getFirstChildElement(jbi);
            if ("component".equals(child.getLocalName())) {
                Component component = DescriptorFactory.parseComponent(child);
                desc.setComponent(component);
            } else if ("shared-library".equals(child.getLocalName())) {
                SharedLibrary sharedLibrary = DescriptorFactory.parseSharedLibrary(child);
                desc.setSharedLibrary(sharedLibrary);
            } else if ("service-assembly".equals(child.getLocalName())) {
                ServiceAssembly serviceAssembly = DescriptorFactory.parseServiceAssembly(child);
                desc.setServiceAssembly(serviceAssembly);
            } else if ("services".equals(child.getLocalName())) {
                Services services = DescriptorFactory.parseServiceUnit(child);
                desc.setServices(services);
            }
            DescriptorFactory.checkDescriptor(desc);
            return desc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Services parseServiceUnit(Element child) {
        Services services = new Services();
        services.setBindingComponent(Boolean.valueOf(DescriptorFactory.getAttribute(child, "binding-component")));
        ArrayList<Provides> provides = new ArrayList<Provides>();
        ArrayList<Consumes> consumes = new ArrayList<Consumes>();
        Element e = DOMUtil.getFirstChildElement(child);
        while (e != null) {
            if ("provides".equals(e.getLocalName())) {
                Provides p = new Provides();
                p.setInterfaceName(DescriptorFactory.readAttributeQName(e, "interface-name"));
                p.setServiceName(DescriptorFactory.readAttributeQName(e, "service-name"));
                p.setEndpointName(DescriptorFactory.getAttribute(e, "endpoint-name"));
                provides.add(p);
            } else if ("consumes".equals(e.getLocalName())) {
                Consumes c = new Consumes();
                c.setInterfaceName(DescriptorFactory.readAttributeQName(e, "interface-name"));
                c.setServiceName(DescriptorFactory.readAttributeQName(e, "service-name"));
                c.setEndpointName(DescriptorFactory.getAttribute(e, "endpoint-name"));
                c.setLinkType(DescriptorFactory.getAttribute(e, "link-type"));
                consumes.add(c);
            }
            e = DOMUtil.getNextSiblingElement(e);
        }
        services.setProvides(provides.toArray(new Provides[provides.size()]));
        services.setConsumes(consumes.toArray(new Consumes[consumes.size()]));
        return services;
    }

    private static ServiceAssembly parseServiceAssembly(Element child) {
        ServiceAssembly serviceAssembly = new ServiceAssembly();
        ArrayList<ServiceUnit> sus = new ArrayList<ServiceUnit>();
        Element e = DOMUtil.getFirstChildElement(child);
        while (e != null) {
            if ("identification".equals(e.getLocalName())) {
                serviceAssembly.setIdentification(DescriptorFactory.readIdentification(e));
            } else if ("service-unit".equals(e.getLocalName())) {
                ServiceUnit su = new ServiceUnit();
                Element e2 = DOMUtil.getFirstChildElement(e);
                while (e2 != null) {
                    if ("identification".equals(e2.getLocalName())) {
                        su.setIdentification(DescriptorFactory.readIdentification(e2));
                    } else if ("target".equals(e2.getLocalName())) {
                        Target target = new Target();
                        Element e3 = DOMUtil.getFirstChildElement(e2);
                        while (e3 != null) {
                            if ("artifacts-zip".equals(e3.getLocalName())) {
                                target.setArtifactsZip(DescriptorFactory.getText(e3));
                            } else if ("component-name".equals(e3.getLocalName())) {
                                target.setComponentName(DescriptorFactory.getText(e3));
                            }
                            e3 = DOMUtil.getNextSiblingElement(e3);
                        }
                        su.setTarget(target);
                    }
                    e2 = DOMUtil.getNextSiblingElement(e2);
                }
                sus.add(su);
            } else if ("connections".equals(e.getLocalName())) {
                Connections connections = new Connections();
                ArrayList<Connection> cns = new ArrayList<Connection>();
                Element e2 = DOMUtil.getFirstChildElement(e);
                while (e2 != null) {
                    if ("connection".equals(e2.getLocalName())) {
                        Connection cn = new Connection();
                        Element e3 = DOMUtil.getFirstChildElement(e2);
                        while (e3 != null) {
                            if ("consumer".equals(e3.getLocalName())) {
                                Consumer consumer = new Consumer();
                                consumer.setInterfaceName(DescriptorFactory.readAttributeQName(e3, "interface-name"));
                                consumer.setServiceName(DescriptorFactory.readAttributeQName(e3, "service-name"));
                                consumer.setEndpointName(DescriptorFactory.getAttribute(e3, "endpoint-name"));
                                cn.setConsumer(consumer);
                            } else if ("provider".equals(e3.getLocalName())) {
                                Provider provider = new Provider();
                                provider.setServiceName(DescriptorFactory.readAttributeQName(e3, "service-name"));
                                provider.setEndpointName(DescriptorFactory.getAttribute(e3, "endpoint-name"));
                                cn.setProvider(provider);
                            }
                            e3 = DOMUtil.getNextSiblingElement(e3);
                        }
                        cns.add(cn);
                    }
                    e2 = DOMUtil.getNextSiblingElement(e2);
                }
                connections.setConnections(cns.toArray(new Connection[cns.size()]));
                serviceAssembly.setConnections(connections);
            }
            e = DOMUtil.getNextSiblingElement(e);
        }
        serviceAssembly.setServiceUnits(sus.toArray(new ServiceUnit[sus.size()]));
        return serviceAssembly;
    }

    private static SharedLibrary parseSharedLibrary(Element child) {
        SharedLibrary sharedLibrary = new SharedLibrary();
        sharedLibrary.setClassLoaderDelegation(DescriptorFactory.getAttribute(child, "class-loader-delegation"));
        sharedLibrary.setVersion(DescriptorFactory.getAttribute(child, "version"));
        Element e = DOMUtil.getFirstChildElement(child);
        while (e != null) {
            if ("identification".equals(e.getLocalName())) {
                sharedLibrary.setIdentification(DescriptorFactory.readIdentification(e));
            } else if ("shared-library-class-path".equals(e.getLocalName())) {
                ClassPath sharedLibraryClassPath = new ClassPath();
                ArrayList<String> l = new ArrayList<String>();
                Element e2 = DOMUtil.getFirstChildElement(e);
                while (e2 != null) {
                    if ("path-element".equals(e2.getLocalName())) {
                        l.add(DescriptorFactory.getText(e2));
                    }
                    e2 = DOMUtil.getNextSiblingElement(e2);
                }
                sharedLibraryClassPath.setPathList(l);
                sharedLibrary.setSharedLibraryClassPath(sharedLibraryClassPath);
            }
            e = DOMUtil.getNextSiblingElement(e);
        }
        return sharedLibrary;
    }

    private static Component parseComponent(Element child) {
        Component component = new Component();
        component.setType(child.getAttribute("type"));
        component.setComponentClassLoaderDelegation(DescriptorFactory.getAttribute(child, "component-class-loader-delegation"));
        component.setBootstrapClassLoaderDelegation(DescriptorFactory.getAttribute(child, "bootstrap-class-loader-delegation"));
        ArrayList<SharedLibraryList> sls = new ArrayList<SharedLibraryList>();
        Node ext = null;
        Element e = DOMUtil.getFirstChildElement(child);
        while (e != null) {
            Element e2;
            ArrayList<String> l;
            if ("identification".equals(e.getLocalName())) {
                component.setIdentification(DescriptorFactory.readIdentification(e));
            } else if ("component-class-name".equals(e.getLocalName())) {
                component.setComponentClassName(DescriptorFactory.getText(e));
                component.setDescription(DescriptorFactory.getAttribute(e, "description"));
            } else if ("component-class-path".equals(e.getLocalName())) {
                ClassPath componentClassPath = new ClassPath();
                l = new ArrayList<String>();
                e2 = DOMUtil.getFirstChildElement(e);
                while (e2 != null) {
                    if ("path-element".equals(e2.getLocalName())) {
                        l.add(DescriptorFactory.getText(e2));
                    }
                    e2 = DOMUtil.getNextSiblingElement(e2);
                }
                componentClassPath.setPathList(l);
                component.setComponentClassPath(componentClassPath);
            } else if ("bootstrap-class-name".equals(e.getLocalName())) {
                component.setBootstrapClassName(DescriptorFactory.getText(e));
            } else if ("bootstrap-class-path".equals(e.getLocalName())) {
                ClassPath bootstrapClassPath = new ClassPath();
                l = new ArrayList();
                e2 = DOMUtil.getFirstChildElement(e);
                while (e2 != null) {
                    if ("path-element".equals(e2.getLocalName())) {
                        l.add(DescriptorFactory.getText(e2));
                    }
                    e2 = DOMUtil.getNextSiblingElement(e2);
                }
                bootstrapClassPath.setPathList(l);
                component.setBootstrapClassPath(bootstrapClassPath);
            } else if ("shared-library".equals(e.getLocalName())) {
                SharedLibraryList sl = new SharedLibraryList();
                sl.setName(DescriptorFactory.getText(e));
                sl.setVersion(DescriptorFactory.getAttribute(e, "version"));
                sls.add(sl);
            } else {
                if (ext == null) {
                    ext = child.getOwnerDocument().createDocumentFragment();
                }
                ext.appendChild(e);
            }
            e = DOMUtil.getNextSiblingElement(e);
        }
        component.setSharedLibraries(sls.toArray(new SharedLibraryList[sls.size()]));
        if (ext != null) {
            InstallationDescriptorExtension descriptorExtension = new InstallationDescriptorExtension();
            descriptorExtension.setDescriptorExtension((DocumentFragment)ext);
            component.setDescriptorExtension(descriptorExtension);
        }
        return component;
    }

    private static String getAttribute(Element e, String name) {
        if (e.hasAttribute(name)) {
            return e.getAttribute(name);
        }
        return null;
    }

    private static QName readAttributeQName(Element e, String name) {
        String attr = DescriptorFactory.getAttribute(e, name);
        if (attr != null) {
            return DOMUtil.createQName(e, attr);
        }
        return null;
    }

    private static String getText(Element e) {
        return DOMUtil.getElementText(e).trim();
    }

    private static Identification readIdentification(Element e) {
        Identification ident = new Identification();
        Element e2 = DOMUtil.getFirstChildElement(e);
        while (e2 != null) {
            if ("name".equals(e2.getLocalName())) {
                ident.setName(DOMUtil.getElementText(e2));
            } else if ("description".equals(e2.getLocalName())) {
                ident.setDescription(DOMUtil.getElementText(e2));
            }
            e2 = DOMUtil.getNextSiblingElement(e2);
        }
        return ident;
    }

    public static void checkDescriptor(Descriptor descriptor) {
        ArrayList<String> violations = new ArrayList<String>();
        if (descriptor.getVersion() != 1.0) {
            violations.add("JBI descriptor version should be set to '1.0' but is " + descriptor.getVersion());
        }
        if (descriptor.getComponent() != null) {
            DescriptorFactory.checkComponent(violations, descriptor.getComponent());
        } else if (descriptor.getServiceAssembly() != null) {
            DescriptorFactory.checkServiceAssembly(violations, descriptor.getServiceAssembly());
        } else if (descriptor.getServices() != null) {
            DescriptorFactory.checkServiceUnit(violations, descriptor.getServices());
        } else if (descriptor.getSharedLibrary() != null) {
            DescriptorFactory.checkSharedLibrary(violations, descriptor.getSharedLibrary());
        } else {
            violations.add("The jbi descriptor does not contain any informations");
        }
        if (violations.size() > 0) {
            throw new RuntimeException("The JBI descriptor is not valid, please correct these violations " + ((Object)violations).toString());
        }
    }

    private static void checkComponent(List<String> violations, Component component) {
        if (component.getIdentification() == null) {
            violations.add("The component has not identification");
        } else if (DescriptorFactory.isBlank(component.getIdentification().getName())) {
            violations.add("The component name is not set");
        }
        if (component.getBootstrapClassName() == null) {
            violations.add("The component has not defined a boot-strap class name");
        }
        if (component.getBootstrapClassPath() == null || component.getBootstrapClassPath().getPathElements() == null) {
            violations.add("The component has not defined any boot-strap class path elements");
        }
    }

    private static void checkServiceAssembly(List<String> violations, ServiceAssembly serviceAssembly) {
        if (serviceAssembly.getIdentification() == null) {
            violations.add("The service assembly has not identification");
        } else if (DescriptorFactory.isBlank(serviceAssembly.getIdentification().getName())) {
            violations.add("The service assembly name is not set");
        }
    }

    private static void checkServiceUnit(List<String> violations, Services services) {
    }

    private static void checkSharedLibrary(List<String> violations, SharedLibrary sharedLibrary) {
        if (sharedLibrary.getIdentification() == null) {
            violations.add("The shared library has not identification");
        } else if (DescriptorFactory.isBlank(sharedLibrary.getIdentification().getName())) {
            violations.add("The shared library name is not set");
        }
    }

    public static String getDescriptorAsText(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileInputStream is = new FileInputStream(descriptorFile);
                FileUtil.copyInputStream(is, os);
                return os.toString();
            }
            catch (Exception e) {
                LOG.debug((Object)("Error reading jbi descritor: " + descriptorFile), (Throwable)e);
            }
        }
        return null;
    }

    private static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

