/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.util.Date;
import javax.jbi.JBIException;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.components.varscheduler.ScheduleIterator;
import org.apache.servicemix.components.varscheduler.Scheduler;
import org.apache.servicemix.components.varscheduler.SchedulerTask;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;

public abstract class PollingComponentSupport
extends ComponentSupport
implements Work {
    private static final Log LOG = LogFactory.getLog(PollingComponentSupport.class);
    private Executor executor;
    private Scheduler scheduler;
    private Date firstTime;
    private long period = 5000L;
    private long delay;
    private SchedulerTask schedulerTask;
    private ScheduleIterator scheduleIterator;
    private boolean started;
    private boolean scheduleExecutedFlag;

    public abstract void poll() throws Exception;

    public void release() {
    }

    public void run() {
        try {
            this.poll();
        }
        catch (Exception e) {
            LOG.error((Object)("Caught exception while polling: " + e), (Throwable)e);
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public Date getFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(Date firstTime) {
        this.firstTime = firstTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized void start() throws JBIException {
        if (!this.started) {
            this.started = true;
            if (this.schedulerTask != null) {
                this.schedulerTask.cancel();
            }
            this.schedulerTask = new PollSchedulerTask();
            this.scheduler.schedule(this.schedulerTask, this.scheduleIterator);
        }
        super.start();
    }

    public synchronized void stop() throws JBIException {
        if (this.schedulerTask != null) {
            this.schedulerTask.cancel();
            this.schedulerTask = null;
        }
        this.scheduleExecutedFlag = false;
        this.started = false;
        super.stop();
    }

    public synchronized void shutDown() throws JBIException {
        this.stop();
        this.scheduler.cancel();
        this.executor.shutdown();
        this.scheduler = null;
        this.scheduleIterator = null;
        this.executor = null;
        super.shutDown();
    }

    protected void init() throws JBIException {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler(true);
        }
        if (this.scheduleIterator == null) {
            this.scheduleIterator = new PollScheduleIterator();
        }
        if (this.executor == null) {
            ComponentContextImpl context = (ComponentContextImpl)this.getContext();
            ExecutorFactory factory = context.getContainer().getExecutorFactory();
            this.executor = factory.createExecutor("component." + context.getComponentName());
        }
        super.init();
    }

    private class PollScheduleIterator
    implements ScheduleIterator {
        private PollScheduleIterator() {
        }

        public Date nextExecution() {
            long nextTime = System.currentTimeMillis();
            if (PollingComponentSupport.this.scheduleExecutedFlag) {
                nextTime += PollingComponentSupport.this.period;
            } else {
                if (PollingComponentSupport.this.firstTime != null) {
                    nextTime = PollingComponentSupport.this.firstTime.getTime();
                }
                nextTime += PollingComponentSupport.this.delay;
                PollingComponentSupport.this.scheduleExecutedFlag = true;
            }
            return PollingComponentSupport.this.started ? new Date(nextTime) : null;
        }
    }

    private class PollSchedulerTask
    extends SchedulerTask {
        private PollSchedulerTask() {
        }

        public void run() {
            try {
                PollingComponentSupport.this.getExecutor().execute((Runnable)((Object)PollingComponentSupport.this));
            }
            catch (Throwable e) {
                LOG.error((Object)("Failed to schedule work: " + e), e);
            }
        }
    }
}

