/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.jaxp.ResourceSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.springframework.core.io.Resource;

public class MockServiceComponent
extends TransformComponentSupport
implements MessageExchangeListener {
    private Source responseContent;
    private String responseXml;
    private Resource responseResource;
    private Map responseProperties;

    public MockServiceComponent() {
    }

    public MockServiceComponent(QName service, String endpoint) {
        super(service, endpoint);
    }

    public Source getResponseContent() {
        if (this.responseContent == null) {
            if (this.responseXml != null) {
                this.responseContent = new StringSource(this.responseXml);
            } else if (this.responseResource != null) {
                return new ResourceSource(this.responseResource);
            }
        }
        return this.responseContent;
    }

    public void setResponseContent(Source responseContent) {
        this.responseContent = responseContent;
    }

    public Map getResponseProperties() {
        return this.responseProperties;
    }

    public void setResponseProperties(Map responseProperties) {
        this.responseProperties = responseProperties;
    }

    public String getResponseXml() {
        return this.responseXml;
    }

    public void setResponseXml(String responseXml) {
        this.responseXml = responseXml;
    }

    public Resource getResponseResource() {
        return this.responseResource;
    }

    public void setResponseResource(Resource responseResource) {
        this.responseResource = responseResource;
    }

    protected void init() throws JBIException {
        super.init();
        if (this.getResponseContent() == null) {
            throw new IllegalArgumentException("You must specify the 'responseContent', 'responseXml' or 'responseResource' properties");
        }
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        this.getMessageTransformer().transform(exchange, in, out);
        out.setContent(this.getResponseContent());
        Map map = this.getResponseProperties();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                out.setProperty(name, value);
            }
        }
        return true;
    }
}

