/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import java.lang.reflect.Modifier;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.scope.DefaultScopedObject;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.SimpleBeanTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.ClassUtils;

public class ScopedProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
BeanFactoryAware {
    private final SimpleBeanTargetSource scopedTargetSource = new SimpleBeanTargetSource();
    private String targetBeanName;
    private Object proxy;
    static /* synthetic */ Class class$org$springframework$aop$framework$AopInfrastructureBean;

    public ScopedProxyFactoryBean() {
        this.setProxyTargetClass(true);
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
        this.scopedTargetSource.setTargetBeanName(targetBeanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        this.scopedTargetSource.setBeanFactory(beanFactory);
        ProxyFactory pf = new ProxyFactory();
        pf.copyFrom(this);
        pf.setTargetSource(this.scopedTargetSource);
        Class beanType = beanFactory.getType(this.targetBeanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot create scoped proxy for bean '" + this.targetBeanName + "': Target type could not be determined at the time of proxy creation.");
        }
        if (!this.isProxyTargetClass() || beanType.isInterface() || Modifier.isPrivate(beanType.getModifiers())) {
            pf.setInterfaces(ClassUtils.getAllInterfacesForClass((Class)beanType));
        }
        DefaultScopedObject scopedObject = new DefaultScopedObject(cbf, this.scopedTargetSource.getTargetBeanName());
        pf.addAdvice(new DelegatingIntroductionInterceptor(scopedObject));
        pf.addInterface(class$org$springframework$aop$framework$AopInfrastructureBean == null ? (class$org$springframework$aop$framework$AopInfrastructureBean = ScopedProxyFactoryBean.class$("org.springframework.aop.framework.AopInfrastructureBean")) : class$org$springframework$aop$framework$AopInfrastructureBean);
        this.proxy = pf.getProxy(cbf.getBeanClassLoader());
    }

    public Object getObject() {
        if (this.proxy == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.scopedTargetSource != null) {
            return this.scopedTargetSource.getTargetClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

