/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicemix.jms.endpoints;

import javax.jbi.messaging.MessageExchange;

/**
 * A pluggable strategy used to decide which JMS Destination to use for an outbound JMS message
 *
 * @version $Revision: 516036 $
 */
public interface DestinationChooser {

    /**
     * Chooses which JMS destintation to use for the given message.
     * The message may be the "in", "out" or "fault" message.
     * 
     * @param exchange the exchange
     * @param message the message can be a javax.jbi.messaging.NormalizedMessage,
     *                a javax.jbi.messaging.Fault or an Exception
     * @return a javax.jms.Destination or String for the destination name
     */
    Object chooseDestination(MessageExchange exchange, Object message);
}
