/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SAMLUtil {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$saml$SAMLUtil == null ? (class$org$apache$ws$security$saml$SAMLUtil = SAMLUtil.class$("org.apache.ws.security.saml.SAMLUtil")) : class$org$apache$ws$security$saml$SAMLUtil).getName());
    static /* synthetic */ Class class$org$apache$ws$security$saml$SAMLUtil;

    public static SAMLKeyInfo getSAMLKeyInfo(Element elem, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        try {
            SAMLAssertion assertion = new SAMLAssertion(elem);
            return SAMLUtil.getSAMLKeyInfo(assertion, crypto, cb);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"}, e);
        }
    }

    public static SAMLKeyInfo getSAMLKeyInfo(SAMLAssertion assertion, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        byte[] key;
        WSPasswordCallback pwcb = new WSPasswordCallback(assertion.getId(), 7);
        if (cb != null) {
            try {
                cb.handle(new Callback[]{pwcb});
            }
            catch (Exception e1) {
                throw new WSSecurityException(0, "noKey", new Object[]{assertion.getId()});
            }
        }
        if ((key = pwcb.getKey()) != null) {
            return new SAMLKeyInfo(assertion, key);
        }
        Iterator statements = assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement stmt = (SAMLStatement)statements.next();
            if (stmt instanceof SAMLAttributeStatement) {
                SAMLAttributeStatement attrStmt = (SAMLAttributeStatement)stmt;
                SAMLSubject samlSubject = attrStmt.getSubject();
                Element kiElem = samlSubject.getKeyInfo();
                NodeList children = kiElem.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    QName el = new QName(child.getNamespaceURI(), child.getLocalName());
                    if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                        EncryptedKeyProcessor proc = new EncryptedKeyProcessor();
                        proc.handleEncryptedKey((Element)child, cb, crypto, null);
                        return new SAMLKeyInfo(assertion, proc.getDecryptedBytes());
                    }
                    if (!el.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret"))) continue;
                    Text txt = (Text)child.getFirstChild();
                    return new SAMLKeyInfo(assertion, Base64.decode(txt.getData()));
                }
                continue;
            }
            if (stmt instanceof SAMLAuthenticationStatement) {
                SAMLAuthenticationStatement authStmt = (SAMLAuthenticationStatement)stmt;
                SAMLSubject samlSubj = authStmt.getSubject();
                if (samlSubj == null) {
                    throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
                }
                Element e = samlSubj.getKeyInfo();
                X509Certificate[] certs = null;
                try {
                    KeyInfo ki = new KeyInfo(e, null);
                    if (!ki.containsX509Data()) continue;
                    X509Data data = ki.itemX509Data(0);
                    XMLX509Certificate certElem = null;
                    if (data != null && data.containsCertificate()) {
                        certElem = data.itemCertificate(0);
                    }
                    if (certElem == null) continue;
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                    return new SAMLKeyInfo(assertion, certs);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"});
                }
            }
            throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
        }
        throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
    }

    public static X509Certificate[] getCertificatesFromSAML(Element elem) throws WSSecurityException {
        SAMLAssertion assertion;
        try {
            assertion = new SAMLAssertion(elem);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"});
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
        }
        Element e = samlSubj.getKeyInfo();
        X509Certificate[] certs = null;
        try {
            KeyInfo ki = new KeyInfo(e, null);
            if (ki.containsX509Data()) {
                X509Data data = ki.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem != null) {
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                }
            }
        }
        catch (XMLSecurityException e3) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"});
        }
        return certs;
    }

    public static String getAssertionId(Element envelope, String elemName, String nmSpace) throws WSSecurityException {
        String id;
        Element assertionElement = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
        try {
            SAMLAssertion assertion = new SAMLAssertion(assertionElement);
            id = assertion.getId();
        }
        catch (Exception e1) {
            log.error((Object)e1);
            throw new WSSecurityException(10, "noXMLSig", null, e1);
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

