/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse.spring;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.CertStoreType;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.SecureRandomParameters;
import org.apache.cxf.configuration.security.TrustManagersType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TLSParameterJaxBUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(TLSParameterJaxBUtils.class);

    private TLSParameterJaxBUtils() {
    }

    public static SecureRandom getSecureRandom(SecureRandomParameters secureRandomParams) throws GeneralSecurityException {
        SecureRandom secureRandom = null;
        if (secureRandomParams != null) {
            String secureRandomAlg = secureRandomParams.getAlgorithm();
            String randomProvider = secureRandomParams.getProvider();
            secureRandom = randomProvider != null ? (secureRandomAlg != null ? SecureRandom.getInstance(secureRandomAlg, randomProvider) : null) : (secureRandomAlg != null ? SecureRandom.getInstance(secureRandomAlg) : null);
        }
        return secureRandom;
    }

    public static KeyStore getKeyStore(KeyStoreType kst) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        if (kst == null) {
            return null;
        }
        String type = kst.isSetType() ? kst.getType() : KeyStore.getDefaultType();
        char[] password = kst.isSetPassword() ? kst.getPassword().toCharArray() : null;
        KeyStore keyStore2 = keyStore = !kst.isSetProvider() ? KeyStore.getInstance(type) : KeyStore.getInstance(type, kst.getProvider());
        if (kst.isSetFile()) {
            keyStore.load(new FileInputStream(kst.getFile()), password);
        }
        if (kst.isSetResource()) {
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)kst.getResource(), kst.getClass());
            if (is == null) {
                String msg = "Could not load keystore resource " + kst.getResource();
                LOG.severe(msg);
                throw new IOException(msg);
            }
            keyStore.load(is, password);
        }
        if (kst.isSetUrl()) {
            keyStore.load(new URL(kst.getUrl()).openStream(), password);
        }
        return keyStore;
    }

    public static KeyStore getKeyStore(CertStoreType pst) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (pst == null) {
            return null;
        }
        if (pst.isSetFile()) {
            return TLSParameterJaxBUtils.createTrustStore(new FileInputStream(pst.getFile()));
        }
        if (pst.isSetResource()) {
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)pst.getResource(), pst.getClass());
            if (is == null) {
                String msg = "Could not load truststore resource " + pst.getResource();
                LOG.severe(msg);
                throw new IOException(msg);
            }
            return TLSParameterJaxBUtils.createTrustStore(is);
        }
        if (pst.isSetUrl()) {
            return TLSParameterJaxBUtils.createTrustStore(new URL(pst.getUrl()).openStream());
        }
        return null;
    }

    private static KeyStore createTrustStore(InputStream is) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Collection<? extends Certificate> certs = TLSParameterJaxBUtils.loadCertificates(is);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        for (Certificate certificate : certs) {
            X509Certificate xcert = (X509Certificate)certificate;
            keyStore.setCertificateEntry(xcert.getSubjectX500Principal().getName(), certificate);
        }
        return keyStore;
    }

    private static Collection<? extends Certificate> loadCertificates(InputStream is) throws IOException, CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificates(is);
    }

    public static KeyManager[] getKeyManagers(KeyManagersType kmc) throws GeneralSecurityException, IOException {
        KeyStore keyStore = TLSParameterJaxBUtils.getKeyStore(kmc.getKeyStore());
        if (keyStore == null) {
            return null;
        }
        String alg = kmc.isSetFactoryAlgorithm() ? kmc.getFactoryAlgorithm() : KeyManagerFactory.getDefaultAlgorithm();
        char[] keyPass = kmc.isSetKeyPassword() ? kmc.getKeyPassword().toCharArray() : null;
        KeyManagerFactory fac = kmc.isSetProvider() ? KeyManagerFactory.getInstance(alg, kmc.getProvider()) : KeyManagerFactory.getInstance(alg);
        fac.init(keyStore, keyPass);
        return fac.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(TrustManagersType tmc) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        KeyStore keyStore2 = tmc.isSetKeyStore() ? TLSParameterJaxBUtils.getKeyStore(tmc.getKeyStore()) : (keyStore = tmc.isSetCertStore() ? TLSParameterJaxBUtils.getKeyStore(tmc.getCertStore()) : (KeyStore)null);
        if (keyStore == null) {
            return null;
        }
        String alg = tmc.isSetFactoryAlgorithm() ? tmc.getFactoryAlgorithm() : KeyManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory fac = tmc.isSetProvider() ? TrustManagerFactory.getInstance(alg, tmc.getProvider()) : TrustManagerFactory.getInstance(alg);
        fac.init(keyStore);
        return fac.getTrustManagers();
    }
}

