/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import com.ibm.wsdl.ImportImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.cxf.binding.corba.utils.EprMetaData;
import org.apache.cxf.binding.corba.wsdl.BindingType;
import org.apache.cxf.common.logging.LogUtils;
import org.omg.CORBA.Object;

public final class CorbaObjectReferenceHelper {
    public static final String WSDLI_NAMESPACE_URI = "http://www.w3.org/2006/01/wsdl-instance";
    public static final String ADDRESSING_NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";
    public static final String ADDRESSING_WSDL_NAMESPACE_URI = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaObjectReferenceHelper.class);

    private CorbaObjectReferenceHelper() {
    }

    public static String getWSDLLocation(Definition wsdlDef) {
        return wsdlDef.getDocumentBaseURI();
    }

    public static QName getServiceName(Binding binding, Definition wsdlDef) {
        LOG.log(Level.FINE, "Getting service name for an object reference");
        Collection services = wsdlDef.getServices().values();
        for (Service serv : services) {
            Collection ports = serv.getPorts().values();
            for (Port pt : ports) {
                if (!pt.getBinding().equals(binding)) continue;
                return serv.getQName();
            }
        }
        return null;
    }

    public static String getEndpointName(Binding binding, Definition wsdlDef) {
        LOG.log(Level.FINE, "Getting endpoint name for an object reference");
        Collection services = wsdlDef.getServices().values();
        for (Service serv : services) {
            Collection ports = serv.getPorts().values();
            for (Port pt : ports) {
                if (!pt.getBinding().equals(binding)) continue;
                return pt.getName();
            }
        }
        return null;
    }

    public static Binding getDefaultBinding(Object obj, Definition wsdlDef) {
        LOG.log(Level.FINEST, "Getting binding for a default object reference");
        Collection bindings = wsdlDef.getBindings().values();
        for (Binding b : bindings) {
            List extElements = b.getExtensibilityElements();
            for (java.lang.Object element : extElements) {
                BindingType type;
                if (!(element instanceof BindingType) || !obj._is_a((type = (BindingType)((java.lang.Object)element)).getRepositoryID())) continue;
                return b;
            }
        }
        return null;
    }

    public static EprMetaData getBindingForTypeId(String repId, Definition wsdlDef) {
        LOG.log(Level.FINE, "RepositoryId " + repId + ", wsdl namespace " + wsdlDef.getTargetNamespace());
        EprMetaData ret = new EprMetaData();
        Collection bindings = wsdlDef.getBindings().values();
        for (Binding b : bindings) {
            List extElements = b.getExtensibilityElements();
            for (java.lang.Object element : extElements) {
                BindingType type;
                if (!(element instanceof BindingType) || !repId.equals((type = (BindingType)((java.lang.Object)element)).getRepositoryID())) continue;
                ret.setCandidateWsdlDef(wsdlDef);
                ret.setBinding(b);
                return ret;
            }
        }
        if (!ret.isValid()) {
            for (List imports : wsdlDef.getImports().values()) {
                for (java.lang.Object imp : imports) {
                    if (!(imp instanceof ImportImpl)) continue;
                    Definition importDef = ((ImportImpl)imp).getDefinition();
                    LOG.log(Level.INFO, "Following import " + importDef.getDocumentBaseURI());
                    ret = CorbaObjectReferenceHelper.getBindingForTypeId(repId, importDef);
                    if (!ret.isValid()) continue;
                    return ret;
                }
            }
        }
        return ret;
    }

    public static String extractTypeIdFromIOR(String url) {
        boolean bigIndian;
        int typeIdStringSize;
        String ret = new String();
        byte[] data = null;
        try {
            data = Hex.decodeHex((char[])url.substring(4).toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException("Failed to convert ascii hex ior to byte[], ior url=" + url, e);
        }
        if (data.length > 0 && (typeIdStringSize = CorbaObjectReferenceHelper.readIntFromAlignedCDREncaps(data, 4, bigIndian = data[0] <= 0)) > 1) {
            ret = CorbaObjectReferenceHelper.readStringFromAlignedCDREncaps(data, 8, typeIdStringSize - 1);
        }
        return ret;
    }

    private static String readStringFromAlignedCDREncaps(byte[] data, int startIndex, int length) {
        char[] arr = new char[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = (char)(data[startIndex + i] & 0xFF);
        }
        return new String(arr);
    }

    public static int readIntFromAlignedCDREncaps(byte[] data, int index, boolean bigEndian) {
        if (bigEndian) {
            int partial = data[index] << 24 & 0xFF000000 | data[index + 1] << 16 & 0xFF0000;
            return partial | data[index + 2] << 8 & 0xFF00 | data[index + 3] & 0xFF;
        }
        int partial = data[index] & 0xFF | data[index + 1] << 8 & 0xFF00;
        return partial | data[index + 2] << 16 & 0xFF0000 | data[index + 3] << 24 & 0xFF000000;
    }

    public static void populateEprInfo(EprMetaData info) {
        if (!info.isValid()) {
            return;
        }
        Binding match = info.getBinding();
        Definition wsdlDef = info.getCandidateWsdlDef();
        Collection services = wsdlDef.getServices().values();
        block0: for (Service serv : services) {
            Collection ports = serv.getPorts().values();
            for (Port pt : ports) {
                if (!pt.getBinding().equals(match)) continue;
                info.setPortName(pt.getName());
                info.setServiceQName(serv.getQName());
                continue block0;
            }
        }
        if (info.getServiceQName() == null) {
            Iterator importLists = wsdlDef.getImports().values().iterator();
            block2: while (info.getServiceQName() == null && importLists.hasNext()) {
                List imports = (List)importLists.next();
                for (java.lang.Object imp : imports) {
                    if (!(imp instanceof ImportImpl)) continue;
                    Definition importDef = ((ImportImpl)imp).getDefinition();
                    LOG.log(Level.FINE, "following wsdl import " + importDef.getDocumentBaseURI());
                    info.setCandidateWsdlDef(importDef);
                    CorbaObjectReferenceHelper.populateEprInfo(info);
                    if (info.getServiceQName() == null) continue;
                    continue block2;
                }
            }
        }
    }
}

