/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.interceptors;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.runtime.CorbaStreamWriter;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.utils.ContextUtils;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.ModeType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaStreamOutEndingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private ORB orb;
    private CorbaTypeMap typeMap;
    private ServiceInfo service;

    public CorbaStreamOutEndingInterceptor() {
        super("user-stream");
    }

    public void handleMessage(Message msg) {
        CorbaMessage message = (CorbaMessage)msg;
        this.orb = (ORB)message.get("orb");
        Exchange exchange = message.getExchange();
        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        this.service = (ServiceInfo)exchange.get(ServiceInfo.class);
        this.typeMap = message.getCorbaTypeMap();
        if (ContextUtils.isRequestor((Message)message)) {
            this.handleOutBoundMessage(message, boi);
        } else {
            this.handleInBoundMessage(message, boi);
        }
    }

    private void handleOutBoundMessage(CorbaMessage message, BindingOperationInfo boi) {
        OperationInfo opInfo = boi.getOperationInfo();
        OperationType opType = (OperationType)((Object)boi.getExtensor(OperationType.class));
        List<ParamType> paramTypes = opType.getParam();
        MessageInfo outMsgInfo = opInfo.getOutput();
        String wrapNSUri = null;
        boolean wrap = false;
        if (boi.isUnwrappedCapable()) {
            wrap = true;
            if (outMsgInfo != null && !CorbaUtils.isElementFormQualified(this.service, wrapNSUri = this.getWrappedParamNamespace(outMsgInfo))) {
                wrapNSUri = "";
            }
        }
        CorbaStreamWriter writer = (CorbaStreamWriter)message.getContent(XMLStreamWriter.class);
        CorbaObjectHandler[] objs = writer.getCorbaObjects();
        int count = 0;
        int msgIndex = 0;
        ArgType returnParam = opType.getReturn();
        if (returnParam != null) {
            QName retName = wrap ? new QName(wrapNSUri, returnParam.getName()) : this.getMessageParamQName(outMsgInfo, returnParam.getName(), msgIndex);
            QName retIdlType = returnParam.getIdltype();
            CorbaObjectHandler obj = CorbaHandlerUtils.initializeObjectHandler(this.orb, retName, retIdlType, this.typeMap, this.service);
            CorbaStreamable streamable = message.createStreamableObject(obj, retName);
            message.setStreamableReturn(streamable);
            ++msgIndex;
        }
        for (ParamType param : paramTypes) {
            QName paramName;
            QName idlType = param.getIdltype();
            CorbaObjectHandler obj = null;
            if (param.getMode().equals((Object)ModeType.OUT)) {
                paramName = wrap ? new QName(wrapNSUri, param.getName()) : this.getMessageParamQName(outMsgInfo, param.getName(), msgIndex);
                obj = CorbaHandlerUtils.initializeObjectHandler(this.orb, paramName, idlType, this.typeMap, this.service);
                ++msgIndex;
            } else {
                obj = objs[count++];
                paramName = obj.getName();
            }
            CorbaStreamable streamable = message.createStreamableObject(obj, paramName);
            ModeType paramMode = param.getMode();
            if (paramMode.value().equals("in")) {
                streamable.setMode(1);
            } else if (paramMode.value().equals("inout")) {
                streamable.setMode(3);
            }
            message.addStreamableArgument(streamable);
        }
    }

    private void handleInBoundMessage(CorbaMessage message, BindingOperationInfo boi) {
        OperationInfo opInfo = boi.getOperationInfo();
        OperationType opType = (OperationType)((Object)boi.getExtensor(OperationType.class));
        List<ParamType> paramTypes = opType.getParam();
        MessageInfo msgInInfo = opInfo.getInput();
        String wrapNSUri = null;
        boolean wrap = false;
        if (boi.isUnwrappedCapable()) {
            wrap = true;
            if (msgInInfo != null && !CorbaUtils.isElementFormQualified(this.service, wrapNSUri = this.getWrappedParamNamespace(msgInInfo))) {
                wrapNSUri = "";
            }
        }
        CorbaStreamWriter writer = (CorbaStreamWriter)message.getContent(XMLStreamWriter.class);
        CorbaObjectHandler[] objs = writer.getCorbaObjects();
        int count = 0;
        int msgIndex = 0;
        ArgType returnParam = opType.getReturn();
        if (returnParam != null) {
            CorbaObjectHandler obj = objs[count++];
            QName retName = obj.getName();
            CorbaStreamable streamable = message.createStreamableObject(obj, retName);
            message.setStreamableReturn(streamable);
        }
        for (ParamType param : paramTypes) {
            QName paramName;
            QName idlType = param.getIdltype();
            CorbaObjectHandler obj = null;
            if (param.getMode().equals((Object)ModeType.IN)) {
                paramName = wrap ? new QName(wrapNSUri, param.getName()) : this.getMessageParamQName(msgInInfo, param.getName(), msgIndex);
                obj = CorbaHandlerUtils.initializeObjectHandler(this.orb, paramName, idlType, this.typeMap, this.service);
                ++msgIndex;
            } else {
                obj = objs[count++];
                paramName = obj.getName();
            }
            CorbaStreamable streamable = message.createStreamableObject(obj, paramName);
            ModeType paramMode = param.getMode();
            if (paramMode.value().equals("in")) {
                streamable.setMode(1);
            } else if (paramMode.value().equals("inout")) {
                streamable.setMode(3);
            } else if (paramMode.value().equals("out")) {
                streamable.setMode(2);
            }
            message.addStreamableArgument(streamable);
        }
    }

    protected QName getMessageParamQName(MessageInfo msgInfo, String paramName, int index) {
        MessagePartInfo part = (MessagePartInfo)msgInfo.getMessageParts().get(index);
        QName paramQName = part != null && part.isElement() ? part.getElementQName() : part.getName();
        return paramQName;
    }

    protected String getWrappedParamNamespace(MessageInfo msgInfo) {
        MessagePartInfo part = (MessagePartInfo)msgInfo.getMessageParts().get(0);
        if (part.isElement()) {
            return part.getElementQName().getNamespaceURI();
        }
        return part.getName().getNamespaceURI();
    }
}

