/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.mtom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.cxf.ws.policy.mtom.MetadataConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTOMAssertionBuilder
implements AssertionBuilder {
    private static final Collection<QName> KNOWN = new ArrayList<QName>();
    private Bus bus;

    public void setBus(Bus b) {
        this.bus = b;
    }

    public PolicyAssertion build(Element elem) {
        Attr attribute;
        String localName = elem.getLocalName();
        QName qn = new QName(elem.getNamespaceURI(), localName);
        boolean optional = false;
        PolicyConstants constants = null;
        if (null != this.bus) {
            constants = (PolicyConstants)this.bus.getExtension(PolicyConstants.class);
        }
        if (null == constants) {
            constants = new PolicyConstants();
        }
        if ((attribute = elem.getAttributeNodeNS(constants.getNamespace(), constants.getOptionalAttrName())) != null) {
            optional = Boolean.valueOf(attribute.getValue());
        }
        if (MetadataConstants.MTOM_ASSERTION_QNAME.equals(qn)) {
            return new PrimitiveAssertion(MetadataConstants.MTOM_ASSERTION_QNAME, optional);
        }
        return null;
    }

    public Collection<QName> getKnownElements() {
        return KNOWN;
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        QName qn = a.getName();
        if (MetadataConstants.MTOM_ASSERTION_QNAME.equals(qn)) {
            PrimitiveAssertionBuilder pab = new PrimitiveAssertionBuilder();
            pab.setKnownElements(Collections.singleton(qn));
            return pab.buildCompatible(a, b);
        }
        return null;
    }

    static {
        KNOWN.add(MetadataConstants.MTOM_ASSERTION_QNAME);
    }
}

