/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathAssert {
    private XPathAssert() {
    }

    public static NodeList assertValid(String xpath, Node node, Map<String, String> namespaces) throws Exception {
        if (node == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        NodeList nodes = (NodeList)XPathAssert.createXPath(namespaces).evaluate(xpath, node, XPathConstants.NODESET);
        if (nodes.getLength() == 0) {
            throw new AssertionFailedError("Failed to select any nodes for expression:\n" + xpath + " from document:\n" + XPathAssert.writeNodeToString(node));
        }
        return nodes;
    }

    public static boolean assertValidBoolean(String xpath, Node node, Map<String, String> namespaces) throws Exception {
        if (node == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        Boolean b = (Boolean)XPathAssert.createXPath(namespaces).evaluate(xpath, node, XPathConstants.BOOLEAN);
        if (b == null) {
            throw new AssertionFailedError("Failed to select any nodes for expression:\n" + xpath + " from document:\n" + XPathAssert.writeNodeToString(node));
        }
        return b;
    }

    private static String writeNodeToString(Node node) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DOMUtils.writeXml((Node)node, (OutputStream)bos);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return bos.toString();
    }

    public static NodeList assertInvalid(String xpath, Node node, Map<String, String> namespaces) throws Exception {
        if (node == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        NodeList nodes = (NodeList)XPathAssert.createXPath(namespaces).evaluate(xpath, node, XPathConstants.NODESET);
        if (nodes.getLength() > 0) {
            String value = XPathAssert.writeNodeToString(node);
            throw new AssertionFailedError("Found multiple nodes for expression:\n" + xpath + "\n" + value);
        }
        return nodes;
    }

    public static void assertXPathEquals(String xpath, String value, Node node, Map<String, String> namespaces) throws Exception {
        Node result = (Node)XPathAssert.createXPath(namespaces).evaluate(xpath, node, XPathConstants.NODE);
        if (result == null) {
            throw new AssertionFailedError("No nodes were found for expression: " + xpath);
        }
        String value2 = DOMUtils.getContent((Node)result).trim();
        Assert.assertEquals((String)value, (String)value2);
    }

    public static void assertNoFault(Node node) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", "http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.put("s12", "http://www.w3.org/2003/05/soap-envelope");
        XPathAssert.assertInvalid("/s:Envelope/s:Body/s:Fault", node, namespaces);
        XPathAssert.assertInvalid("/s12:Envelope/s12:Body/s12:Fault", node, namespaces);
    }

    public static void assertFault(Node node) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", "http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.put("s12", "http://www.w3.org/2003/05/soap-envelope");
        XPathAssert.assertValid("/s:Envelope/s:Body/s:Fault", node, namespaces);
        XPathAssert.assertValid("/s12:Envelope/s12:Body/s12:Fault", node, namespaces);
    }

    public static XPath createXPath(Map<String, String> namespaces) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (namespaces != null) {
            xpath.setNamespaceContext(new MapNamespaceContext(namespaces));
        }
        return xpath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaces;

        public MapNamespaceContext(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
                if (!e.getValue().equals(namespaceURI)) continue;
                return e.getKey();
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

