/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.marshalers;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.w3c.dom.DocumentFragment;

public class JBIMarshaler {
    public static final String SOAP_FAULT_CODE = "org.apache.servicemix.soap.fault.code";
    public static final String SOAP_FAULT_SUBCODE = "org.apache.servicemix.soap.fault.subcode";
    public static final String SOAP_FAULT_REASON = "org.apache.servicemix.soap.fault.reason";
    public static final String SOAP_FAULT_NODE = "org.apache.servicemix.soap.fault.node";
    public static final String SOAP_FAULT_ROLE = "org.apache.servicemix.soap.fault.role";

    public void toNMS(NormalizedMessage normalizedMessage, SoapMessage soapMessage) throws Exception {
        if (soapMessage.hasHeaders()) {
            normalizedMessage.setProperty("org.apache.servicemix.soap.headers", (Object)soapMessage.getHeaders());
        }
        if (soapMessage.hasAttachments()) {
            Map attachments = soapMessage.getAttachments();
            for (Map.Entry entry : attachments.entrySet()) {
                normalizedMessage.addAttachment((String)entry.getKey(), (DataHandler)entry.getValue());
            }
        }
        normalizedMessage.setSecuritySubject(soapMessage.getSubject());
        if (soapMessage.getFault() != null) {
            if (!(normalizedMessage instanceof Fault)) {
                throw new IllegalStateException("The soap message is a fault but the jbi message is not");
            }
            SoapFault fault = soapMessage.getFault();
            normalizedMessage.setProperty(SOAP_FAULT_CODE, (Object)fault.getCode());
            normalizedMessage.setProperty(SOAP_FAULT_SUBCODE, (Object)fault.getSubcode());
            normalizedMessage.setProperty(SOAP_FAULT_REASON, (Object)fault.getReason());
            normalizedMessage.setProperty(SOAP_FAULT_NODE, (Object)fault.getNode());
            normalizedMessage.setProperty(SOAP_FAULT_ROLE, (Object)fault.getRole());
            normalizedMessage.setContent(fault.getDetails());
        } else {
            normalizedMessage.setContent(soapMessage.getSource());
        }
    }

    public void fromNMS(SoapMessage soapMessage, NormalizedMessage normalizedMessage) {
        if (normalizedMessage.getProperty("org.apache.servicemix.soap.headers") != null) {
            Map headers = (Map)normalizedMessage.getProperty("org.apache.servicemix.soap.headers");
            for (Map.Entry entry : headers.entrySet()) {
                soapMessage.addHeader((QName)entry.getKey(), (DocumentFragment)entry.getValue());
            }
        }
        Set attachmentNames = normalizedMessage.getAttachmentNames();
        for (String string : attachmentNames) {
            DataHandler handler = normalizedMessage.getAttachment(string);
            soapMessage.addAttachment(string, handler);
        }
        soapMessage.setSubject(normalizedMessage.getSecuritySubject());
        if (normalizedMessage instanceof Fault) {
            QName code = (QName)normalizedMessage.getProperty(SOAP_FAULT_CODE);
            QName qName = (QName)normalizedMessage.getProperty(SOAP_FAULT_SUBCODE);
            String reason = (String)normalizedMessage.getProperty(SOAP_FAULT_REASON);
            URI node = (URI)normalizedMessage.getProperty(SOAP_FAULT_NODE);
            URI role = (URI)normalizedMessage.getProperty(SOAP_FAULT_ROLE);
            SoapFault fault = new SoapFault(code, qName, reason, node, role, normalizedMessage.getContent());
            soapMessage.setFault(fault);
        } else {
            soapMessage.setSource(normalizedMessage.getContent());
        }
    }
}

