/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util.dom;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XPathUtils {
    private static Node getPreviousTypedNode(Node node, short s) {
        for (node = node.getPreviousSibling(); node != null && node.getNodeType() != s; node = node.getPreviousSibling()) {
        }
        return node;
    }

    private static Node getNextTypedNode(Node node, short s) {
        for (node = node.getNextSibling(); node != null && node.getNodeType() != s; node = node.getNextSibling()) {
        }
        return node;
    }

    private static String getValue(Node node, short s) {
        switch (s) {
            case 1: {
                return ((Element)node).getTagName();
            }
            case 3: {
                return ((Text)node).getData();
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
        }
        return "";
    }

    private static short getNodeType(Node node) {
        return node != null ? (short)node.getNodeType() : (short)-1;
    }

    private static String getXPathFromVector(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            Node node = (Node)vector.elementAt(i);
            short s = XPathUtils.getNodeType(node);
            String string2 = XPathUtils.getValue(node, s);
            int n2 = 1;
            node = XPathUtils.getPreviousTypedNode(node, s);
            while (node != null) {
                if (s == 1) {
                    if (XPathUtils.getValue(node, s).equals(string2)) {
                        ++n2;
                    }
                } else {
                    ++n2;
                }
                node = XPathUtils.getPreviousTypedNode(node, s);
            }
            boolean bl2 = bl = n2 > 1;
            if (!bl) {
                node = (Node)vector.elementAt(i);
                node = XPathUtils.getNextTypedNode(node, s);
                while (!bl && node != null) {
                    if (s == 1) {
                        if (XPathUtils.getValue(node, s).equals(string2)) {
                            bl = true;
                            continue;
                        }
                        node = XPathUtils.getNextTypedNode(node, s);
                        continue;
                    }
                    bl = true;
                }
            }
            switch (s) {
                case 3: {
                    string = "text()";
                    break;
                }
                case 7: {
                    string = "processing-instruction()";
                    break;
                }
                default: {
                    string = string2;
                }
            }
            if (string != null && string.length() > 0) {
                stringBuffer.append('/' + string);
            }
            if (!bl) continue;
            stringBuffer.append("[" + n2 + "]");
        }
        return stringBuffer.toString();
    }

    private static Vector getVectorPathFromNode(Node node) {
        Vector<Node> vector = new Vector<Node>();
        while (node != null) {
            vector.insertElementAt(node, 0);
            node = node.getParentNode();
        }
        return vector;
    }

    public static String getXPathExprFromNode(Node node) throws IllegalArgumentException {
        short s = XPathUtils.getNodeType(node);
        switch (s) {
            case 1: 
            case 3: 
            case 7: {
                return XPathUtils.getXPathFromVector(XPathUtils.getVectorPathFromNode(node));
            }
            case 9: {
                return "/";
            }
        }
        throw new IllegalArgumentException("Only works for element, text, document, and PI nodes.");
    }
}

