/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;

public class EndpointDeliveryChannel
implements DeliveryChannel {
    private final DeliveryChannel channel;
    private final Endpoint endpoint;

    public EndpointDeliveryChannel(Endpoint endpoint) throws MessagingException {
        this.endpoint = endpoint;
        this.channel = endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
    }

    public MessageExchange accept() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchange accept(long timeout) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public void close() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchangeFactory createExchangeFactory() {
        return this.channel.createExchangeFactory();
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        return this.channel.createExchangeFactory(interfaceName);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        return this.channel.createExchangeFactory(endpoint);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        return this.channel.createExchangeFactoryForService(serviceName);
    }

    public void send(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.getRole() == MessageExchange.Role.CONSUMER) {
            ServiceMixComponent comp = this.endpoint.getServiceUnit().getComponent();
            comp.prepareConsumerExchange(exchange, this.endpoint);
        }
        this.channel.send(exchange);
    }

    public boolean sendSync(MessageExchange exchange, long timeout) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.getRole() == MessageExchange.Role.CONSUMER) {
            ServiceMixComponent comp = this.endpoint.getServiceUnit().getComponent();
            comp.prepareConsumerExchange(exchange, this.endpoint);
        }
        return this.channel.sendSync(exchange, timeout);
    }

    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.getRole() == MessageExchange.Role.CONSUMER) {
            ServiceMixComponent comp = this.endpoint.getServiceUnit().getComponent();
            comp.prepareConsumerExchange(exchange, this.endpoint);
        }
        return this.channel.sendSync(exchange);
    }
}

