/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.jbi;

import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Binding;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.model.SoapOperation;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.QNameUtil;
import org.w3c.dom.DocumentFragment;

public class JbiOutInterceptor
extends AbstractInterceptor {
    private final boolean server;

    public JbiOutInterceptor(boolean server) {
        this.server = server;
    }

    public void handleMessage(Message message) {
        NormalizedMessage nm = message.getContent(NormalizedMessage.class);
        message.setContent(Source.class, nm.getContent());
        this.fromNMSAttachments(message, nm);
        this.fromNMSHeaders(message, nm);
        if (!this.server) {
            MessageExchange me = message.getContent(MessageExchange.class);
            Binding binding = message.get(Binding.class);
            Object operation = binding.getOperation(me.getOperation());
            if (operation != null) {
                if (!me.getPattern().equals(operation.getMep())) {
                    throw new Fault("Received incorrect exchange mep.  Received " + me.getPattern() + " but expected " + operation.getMep() + " for operation " + operation.getName());
                }
                message.put(Operation.class, operation);
                if (operation instanceof SoapOperation) {
                    String soapAction = ((SoapOperation)operation).getSoapAction();
                    message.getTransportHeaders().put("SOAPAction", soapAction);
                }
            }
        }
    }

    private void fromNMSAttachments(Message message, NormalizedMessage normalizedMessage) {
        Set attachmentNames = normalizedMessage.getAttachmentNames();
        for (String id : attachmentNames) {
            DataHandler handler = normalizedMessage.getAttachment(id);
            message.getAttachments().put(id, handler);
        }
    }

    private void fromNMSHeaders(Message message, NormalizedMessage normalizedMessage) {
        if (normalizedMessage.getProperty("javax.jbi.messaging.protocol.headers") != null) {
            Map headers = (Map)normalizedMessage.getProperty("javax.jbi.messaging.protocol.headers");
            for (Map.Entry entry : headers.entrySet()) {
                QName name = QNameUtil.parse((String)entry.getKey());
                if (name != null) {
                    message.getSoapHeaders().put(name, (DocumentFragment)entry.getValue());
                    continue;
                }
                message.getTransportHeaders().put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

