/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.jbi;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapBinding;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapMessage;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapPart;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.interceptors.jbi.JbiConstants;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.QNameUtil;
import org.apache.servicemix.soap.util.stax.StaxUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JbiInWsdl1Interceptor
extends AbstractInterceptor {
    private final boolean server;

    public JbiInWsdl1Interceptor(boolean server) {
        this.server = server;
    }

    public void handleMessage(Message message) {
        if (message.getContent(Exception.class) != null) {
            return;
        }
        if (message.get("useJbiWrapper") instanceof Boolean && !((Boolean)message.get("useJbiWrapper")).booleanValue()) {
            XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
            if (xmlReader != null) {
                message.setContent(Source.class, StaxUtil.createSource(xmlReader));
            }
            return;
        }
        Wsdl1SoapOperation wsdlOperation = this.getOperation(message);
        Wsdl1SoapMessage wsdlMessage = this.server ? (Wsdl1SoapMessage)wsdlOperation.getInput() : (Wsdl1SoapMessage)wsdlOperation.getOutput();
        Document document = DomUtil.createDocument();
        Element root = DomUtil.createElement(document, JbiConstants.WSDL11_WRAPPER_MESSAGE);
        String typeNamespace = wsdlMessage.getName().getNamespaceURI();
        if (typeNamespace == null || typeNamespace.length() == 0) {
            throw new IllegalArgumentException("messageType namespace is null or empty");
        }
        root.setAttribute("xmlns:msg", typeNamespace);
        String typeLocalName = wsdlMessage.getName().getLocalPart();
        if (typeLocalName == null || typeLocalName.length() == 0) {
            throw new IllegalArgumentException("messageType local name is null or empty");
        }
        root.setAttribute("type", "msg:" + typeLocalName);
        String messageName = wsdlMessage.getMessageName();
        root.setAttribute("name", messageName);
        root.setAttribute("version", "1.0");
        Element body = this.getBodyElement(message);
        for (Wsdl1SoapPart part : wsdlMessage.getParts()) {
            if (part.isBody()) {
                if (wsdlOperation.getStyle() == Wsdl1SoapBinding.Style.DOCUMENT) {
                    JbiInWsdl1Interceptor.addPart(root, body);
                    continue;
                }
                Element param = DomUtil.getFirstChildElement(body);
                boolean found = false;
                while (param != null) {
                    if (part.getName().equals(param.getLocalName())) {
                        found = true;
                        JbiInWsdl1Interceptor.addPart(root, param.getChildNodes());
                    }
                    param = DomUtil.getNextSiblingElement(param);
                }
                if (found) continue;
                throw new SoapFault(SoapFault.SENDER, "Missing part '" + part.getName() + "'");
            }
            QName element = part.getElement();
            DocumentFragment header = message.getSoapHeaders().remove(element);
            if (header == null) {
                throw new SoapFault(SoapFault.SENDER, "Missing required header element: " + QNameUtil.toString(element));
            }
            JbiInWsdl1Interceptor.addPart(root, header.getChildNodes());
        }
        message.setContent(Source.class, new DOMSource(document));
    }

    protected Wsdl1SoapOperation getOperation(Message message) {
        Operation operation = message.get(Operation.class);
        if (operation == null) {
            throw new Fault("Operation not bound on this message");
        }
        if (!(operation instanceof Wsdl1SoapOperation)) {
            throw new Fault("Message is not bound to a WSDL 1.1 SOAP operation");
        }
        return (Wsdl1SoapOperation)operation;
    }

    protected Element getBodyElement(Message message) {
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        return xmlReader != null ? StaxUtil.createElement(xmlReader) : null;
    }

    private static void addPart(Element parent, Node partValue) {
        Element element = DomUtil.createElement(parent, JbiConstants.WSDL11_WRAPPER_PART);
        element.appendChild(element.getOwnerDocument().importNode(partValue, true));
    }

    private static void addPart(Element parent, NodeList nodes) {
        Element element = DomUtil.createElement(parent, JbiConstants.WSDL11_WRAPPER_PART);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            element.appendChild(element.getOwnerDocument().importNode(node, true));
        }
    }
}

