/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.servicemix.soap.api.Interceptor;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.SoapConstants;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.SoapInterceptor;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapMessage;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.apache.servicemix.soap.bindings.soap.model.wsdl1.Wsdl1SoapPart;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MustUnderstandInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        HashSet<URI> serviceRoles = new HashSet<URI>();
        HashSet<QName> headerQNames = new HashSet<QName>();
        HashSet<QName> understoodQNames = new HashSet<QName>();
        this.buildMustUnderstandHeaders(headerQNames, message, serviceRoles);
        this.initServiceSideInfo(understoodQNames, message, serviceRoles);
        headerQNames.removeAll(understoodQNames);
        if (!headerQNames.isEmpty()) {
            StringBuffer sb = new StringBuffer(300);
            int pos = 0;
            for (QName qname : headerQNames) {
                pos = pos + qname.toString().length() + 2;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(qname.toString());
            }
            throw new SoapFault(SoapConstants.SOAP_12_CODE_MUSTUNDERSTAND, sb.toString());
        }
    }

    private void initServiceSideInfo(Set<QName> understoodQNames, Message message, Set<URI> serviceRoles) {
        Operation operation = message.get(Operation.class);
        if (operation instanceof Wsdl1SoapOperation) {
            Wsdl1SoapOperation soapOper = (Wsdl1SoapOperation)operation;
            for (Wsdl1SoapPart part : ((Wsdl1SoapMessage)soapOper.getInput()).getParts()) {
                if (!part.isHeader()) continue;
                understoodQNames.add(part.getElement());
            }
        }
        InterceptorChain chain = message.get(InterceptorChain.class);
        for (Interceptor interceptorInstance : chain.getInterceptors()) {
            if (!(interceptorInstance instanceof SoapInterceptor)) continue;
            SoapInterceptor si = (SoapInterceptor)interceptorInstance;
            serviceRoles.addAll(si.getRoles());
            understoodQNames.addAll(si.getUnderstoodHeaders());
        }
    }

    private void buildMustUnderstandHeaders(Set<QName> mustUnderstandHeaders, Message message, Set<URI> serviceRoles) {
        SoapVersion soapVersion = message.get(SoapVersion.class);
        for (DocumentFragment df : message.getSoapHeaders().values()) {
            for (int i = 0; i < df.getChildNodes().getLength(); ++i) {
                Element header;
                String mustUnderstand;
                if (!(df.getChildNodes().item(i) instanceof Element) || !Boolean.valueOf(mustUnderstand = (header = (Element)df.getChildNodes().item(i)).getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand())).booleanValue() && !"1".equals(mustUnderstand.trim())) continue;
                String role = header.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                QName headerName = new QName(header.getNamespaceURI(), header.getLocalName());
                if ((role = role.trim()) != null && role.length() > 0) {
                    if ((role = role.trim()).equals(soapVersion.getNextRole()) || role.equals(soapVersion.getUltimateReceiverRole())) {
                        mustUnderstandHeaders.add(headerName);
                        continue;
                    }
                    for (URI roleFromBinding : serviceRoles) {
                        if (!role.equals(roleFromBinding)) continue;
                        mustUnderstandHeaders.add(headerName);
                    }
                    continue;
                }
                mustUnderstandHeaders.add(headerName);
            }
        }
    }
}

