/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.tools;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12AddressImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BodyImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12FaultImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12OperationImpl;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;

public final class PortTypeDecorator {
    private PortTypeDecorator() {
    }

    public static Definition createImportDef(Definition definition, String targetNamespace, String importUri) throws Exception {
        Definition def = WSDLFactory.newInstance().newDefinition();
        def.setTargetNamespace(targetNamespace);
        Map namespaces = definition.getNamespaces();
        for (String prefix : namespaces.keySet()) {
            String uri = definition.getNamespace(prefix);
            def.addNamespace(prefix, uri);
        }
        def.addNamespace("tns", targetNamespace);
        def.addNamespace("tnspt", definition.getTargetNamespace());
        Import imp = def.createImport();
        imp.setNamespaceURI(definition.getTargetNamespace());
        imp.setLocationURI(importUri);
        imp.setDefinition(definition);
        def.addImport(imp);
        return def;
    }

    public static void decorate(Definition def, PortType portType, String locationUri) throws Exception {
        PortTypeDecorator.decorate(def, portType, locationUri, portType.getQName().getLocalPart() + "Binding", portType.getQName().getLocalPart() + "Service", "JBI", "1.1");
    }

    public static void decorate(Definition def, PortType portType, String locationUri, String bindingName, String serviceName, String portName, String soapVersion) throws Exception {
        SOAPAddressImpl address;
        SOAPBindingImpl soap;
        boolean soap11 = "1.1".equals(soapVersion);
        if (soap11) {
            def.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        } else {
            def.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap12/");
        }
        Binding binding = def.createBinding();
        binding.setQName(new QName(def.getTargetNamespace(), bindingName));
        binding.setPortType(portType);
        binding.setUndefined(false);
        if (soap11) {
            soap = new SOAPBindingImpl();
            soap.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            soap.setStyle("document");
            binding.addExtensibilityElement((ExtensibilityElement)soap);
        } else {
            soap = new SOAP12BindingImpl();
            soap.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            soap.setStyle("document");
            binding.addExtensibilityElement((ExtensibilityElement)soap);
        }
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            BindingOperation bindingOp = PortTypeDecorator.createBindingOperation(def, soap11, operation);
            binding.addBindingOperation(bindingOp);
        }
        def.addBinding(binding);
        Service service = def.createService();
        service.setQName(new QName(def.getTargetNamespace(), serviceName));
        Port port = def.createPort();
        port.setName(portName);
        port.setBinding(binding);
        if (soap11) {
            address = new SOAPAddressImpl();
            address.setLocationURI(locationUri);
            port.addExtensibilityElement((ExtensibilityElement)address);
        } else {
            address = new SOAP12AddressImpl();
            address.setLocationURI(locationUri);
            port.addExtensibilityElement((ExtensibilityElement)address);
        }
        service.addPort(port);
        def.addService(service);
    }

    private static BindingOperation createBindingOperation(Definition def, boolean soap11, Operation operation) {
        SOAPBodyImpl body;
        SOAPOperationImpl op;
        BindingOperation bindingOp = def.createBindingOperation();
        bindingOp.setName(operation.getName());
        if (soap11) {
            op = new SOAPOperationImpl();
            op.setSoapActionURI("");
            bindingOp.addExtensibilityElement((ExtensibilityElement)op);
        } else {
            op = new SOAP12OperationImpl();
            op.setSoapActionURI("");
            bindingOp.addExtensibilityElement((ExtensibilityElement)op);
        }
        if (operation.getInput() != null) {
            BindingInput in = def.createBindingInput();
            in.setName(operation.getInput().getName());
            if (soap11) {
                body = new SOAPBodyImpl();
                body.setUse("literal");
                in.addExtensibilityElement((ExtensibilityElement)body);
            } else {
                body = new SOAP12BodyImpl();
                body.setUse("literal");
                in.addExtensibilityElement((ExtensibilityElement)body);
            }
            bindingOp.setBindingInput(in);
        }
        if (operation.getOutput() != null) {
            BindingOutput out = def.createBindingOutput();
            out.setName(operation.getOutput().getName());
            if (soap11) {
                body = new SOAPBodyImpl();
                body.setUse("literal");
                out.addExtensibilityElement((ExtensibilityElement)body);
            } else {
                body = new SOAP12BodyImpl();
                body.setUse("literal");
                out.addExtensibilityElement((ExtensibilityElement)body);
            }
            bindingOp.setBindingOutput(out);
        }
        for (Fault fault : operation.getFaults().values()) {
            SOAPFaultImpl soapFault;
            BindingFault bindingFault = def.createBindingFault();
            bindingFault.setName(fault.getName());
            if (soap11) {
                soapFault = new SOAPFaultImpl();
                soapFault.setUse("literal");
                soapFault.setName(fault.getName());
                bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
            } else {
                soapFault = new SOAP12FaultImpl();
                soapFault.setUse("literal");
                soapFault.setName(fault.getName());
                bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
            }
            bindingOp.addBindingFault(bindingFault);
        }
        return bindingOp;
    }

    public static Definition decorate(Definition definition, String importUri, String targetNamespace, String locationUri) throws Exception {
        Definition def = PortTypeDecorator.createImportDef(definition, targetNamespace, importUri);
        for (PortType portType : definition.getPortTypes().values()) {
            PortTypeDecorator.decorate(def, portType, locationUri);
        }
        return def;
    }
}

