/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.processors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.jbi.JBIException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;
import org.mortbay.resource.Resource;
import org.springframework.core.io.ClassPathResource;

public class CommonsHttpSSLSocketFactory
implements SecureProtocolSocketFactory {
    private SSLSocketFactory factory;

    public CommonsHttpSSLSocketFactory(SslParameters ssl, KeystoreManager keystoreManager) throws Exception {
        if (ssl.isManaged()) {
            this.createManagedFactory(ssl, keystoreManager);
        } else {
            this.createUnmanagedFactory(ssl);
        }
    }

    protected final void createManagedFactory(SslParameters ssl, KeystoreManager keystoreManager) throws Exception {
        this.factory = keystoreManager.createSSLFactory(ssl.getProvider(), ssl.getProtocol(), ssl.getKeyManagerFactoryAlgorithm(), ssl.getKeyStore(), ssl.getKeyAlias(), ssl.getTrustStore());
    }

    protected final void createUnmanagedFactory(SslParameters ssl) throws Exception {
        String keyStorePassword;
        SSLContext context = ssl.getProvider() == null ? SSLContext.getInstance(ssl.getProtocol()) : SSLContext.getInstance(ssl.getProtocol(), ssl.getProvider());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(ssl.getKeyManagerFactoryAlgorithm());
        String keyStore = ssl.getKeyStore();
        if (keyStore == null && (keyStore = System.getProperty("javax.net.ssl.keyStore")) == null) {
            throw new IllegalArgumentException("keyStore or system property javax.net.ssl.keyStore must be set");
        }
        if (keyStore.startsWith("classpath:")) {
            try {
                String res = keyStore.substring(10);
                URL url = new ClassPathResource(res).getURL();
                keyStore = url.toString();
            }
            catch (IOException e) {
                throw new JBIException("Unable to find keyStore " + keyStore, (Throwable)e);
            }
        }
        if ((keyStorePassword = ssl.getKeyStorePassword()) == null && (keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) == null) {
            throw new IllegalArgumentException("keyStorePassword or system property javax.net.ssl.keyStorePassword must be set");
        }
        String trustStore = ssl.getTrustStore();
        String trustStorePassword = null;
        if (trustStore == null) {
            trustStore = System.getProperty("javax.net.ssl.trustStore");
        }
        if (trustStore != null) {
            if (trustStore.startsWith("classpath:")) {
                try {
                    String res = trustStore.substring(10);
                    URL url = new ClassPathResource(res).getURL();
                    trustStore = url.toString();
                }
                catch (IOException e) {
                    throw new JBIException("Unable to find trustStore " + trustStore, (Throwable)e);
                }
            }
            if ((trustStorePassword = ssl.getTrustStorePassword()) == null && (trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword")) == null) {
                throw new IllegalArgumentException("trustStorePassword or system property javax.net.ssl.trustStorePassword must be set");
            }
        }
        KeyStore ks = KeyStore.getInstance(ssl.getKeyStoreType());
        ks.load(Resource.newResource((String)keyStore).getInputStream(), keyStorePassword.toCharArray());
        keyManagerFactory.init(ks, ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : keyStorePassword.toCharArray());
        if (trustStore != null) {
            KeyStore ts = KeyStore.getInstance(ssl.getTrustStoreType());
            ts.load(Resource.newResource((String)trustStore).getInputStream(), trustStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(ssl.getTrustManagerFactoryAlgorithm());
            trustManagerFactory.init(ts);
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        } else {
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        }
        this.factory = context.getSocketFactory();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.factory.createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = this.factory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }
}

