/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import org.apache.servicemix.expression.JAXPStringXPathExpression;
import org.apache.servicemix.http.endpoints.DefaultHttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.w3c.dom.Node;

public class RestProviderMarshaler
extends DefaultHttpProviderMarshaler {
    private SourceTransformer transformer = new SourceTransformer();
    private JAXPStringXPathExpression contentExpression;

    public JAXPStringXPathExpression getContentExpression() {
        return this.contentExpression;
    }

    public void setContentExpression(JAXPStringXPathExpression contentExpression) {
        this.contentExpression = contentExpression;
    }

    public void createRequest(MessageExchange exchange, NormalizedMessage inMsg, SmxHttpExchange httpExchange) throws Exception {
        httpExchange.setURL(this.getLocationUri(exchange, inMsg));
        httpExchange.addRequestHeader(HttpHeaders.HOST_BUFFER, (Buffer)new ByteArrayBuffer(new URI(this.getLocationUri(exchange, inMsg)).getHost()));
        httpExchange.setMethod(this.getMethod(exchange, inMsg));
        httpExchange.setRequestHeader("Content-Type", this.getContentType(exchange, inMsg));
        if (this.getHeaders() != null) {
            for (Map.Entry<String, String> e : this.getHeaders().entrySet()) {
                httpExchange.setRequestHeader(e.getKey(), e.getValue());
            }
        }
        if (this.contentExpression != null) {
            String contentToSend = this.applyContentExpression(exchange, inMsg);
            if (contentToSend != null) {
                httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(contentToSend.getBytes()));
            }
        } else if (inMsg.getContent() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.transformer.toResult(inMsg.getContent(), (Result)new StreamResult(baos));
            httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
        }
    }

    protected String applyContentExpression(MessageExchange exchange, NormalizedMessage inMsg) throws Exception {
        String content = null;
        if (this.contentExpression != null) {
            Node node = (Node)this.contentExpression.evaluate(exchange, inMsg, XPathConstants.NODE);
            content = this.transformer.toString((Source)new DOMSource(node));
        }
        if (content == null) {
            throw new IllegalStateException("XPath expression failed. Unable to find Content for exchange");
        }
        return content;
    }

    public void handleResponse(MessageExchange exchange, SmxHttpExchange httpExchange) throws Exception {
        int response = httpExchange.getResponseStatus();
        if (exchange instanceof InOnly) {
            this.processInOnly(exchange, response);
        } else if (this.isSuccessful(response)) {
            NormalizedMessage msg = exchange.createMessage();
            msg.setContent((Source)this.packageHttpResponse(httpExchange, response));
            exchange.setMessage(msg, "out");
        } else {
            Fault fault = exchange.createFault();
            fault.setContent((Source)this.packageHttpResponse(httpExchange, response));
            exchange.setFault(fault);
        }
    }

    private void processInOnly(MessageExchange exchange, int response) throws Exception {
        if (!this.isSuccessful(response)) {
            throw new Exception("Invalid status response: " + response);
        }
        exchange.setStatus(ExchangeStatus.DONE);
    }

    public boolean isSuccessful(int httpStatusCode) {
        return httpStatusCode == 200 || httpStatusCode == 201 || httpStatusCode == 202 || httpStatusCode == 204;
    }

    public StreamSource packageHttpResponse(SmxHttpExchange httpExchange, int response) throws UnsupportedEncodingException {
        StringBuffer responseBuffer = new StringBuffer();
        responseBuffer.append("<response>");
        responseBuffer.append("<http-status>");
        responseBuffer.append("<code>" + response + "</code>");
        responseBuffer.append("</http-status>");
        responseBuffer.append("<http-headers>");
        Iterator responseFields = httpExchange.getResponseFields().getFields();
        while (responseFields.hasNext()) {
            HttpFields.Field httpField = (HttpFields.Field)responseFields.next();
            responseBuffer.append("<");
            responseBuffer.append(httpField.getName());
            responseBuffer.append(">");
            responseBuffer.append(httpField.getValue());
            responseBuffer.append("</");
            responseBuffer.append(httpField.getName());
            responseBuffer.append(">");
        }
        responseBuffer.append("</http-headers>");
        if (httpExchange.getResponseData() != null) {
            responseBuffer.append("<content>");
            responseBuffer.append(httpExchange.getResponseContent());
            responseBuffer.append("</content>");
        } else {
            responseBuffer.append("<content/>");
        }
        responseBuffer.append("</response>");
        return new StreamSource(new InputStreamReader((InputStream)new ByteArrayInputStream(responseBuffer.toString().getBytes()), "utf-8"));
    }
}

