/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.InterceptorProvider;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.api.model.Binding;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSoapProviderMarshaler
implements HttpProviderMarshaler {
    private Binding<?> binding;
    private boolean useJbiWrapper = true;
    private Policy[] policies;
    private String baseUrl;
    private String soapAction;

    public Binding<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Binding<?> binding) {
        this.binding = binding;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public void createRequest(MessageExchange exchange, NormalizedMessage inMsg, SmxHttpExchange httpExchange) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Message msg = this.binding.createMessage();
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)inMsg);
        msg.setContent(OutputStream.class, (Object)baos);
        exchange.setProperty(Message.class.getName(), (Object)msg);
        InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientOut);
        phaseOut.doIntercept(msg);
        httpExchange.setMethod("POST");
        httpExchange.setURL(this.baseUrl);
        httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
        for (String header : msg.getTransportHeaders().keySet()) {
            httpExchange.setRequestHeader(header, (String)msg.getTransportHeaders().get(header));
        }
        if (this.soapAction != null) {
            httpExchange.setRequestHeader("SOAPAction", this.soapAction);
        }
    }

    @Override
    public void handleResponse(MessageExchange exchange, SmxHttpExchange httpExchange) throws Exception {
        Message req = (Message)exchange.getProperty(Message.class.getName());
        exchange.setProperty(Message.class.getName(), null);
        Message msg = this.binding.createMessage(req);
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(httpExchange.getResponseData()));
        msg.put((Object)"Encoding", (Object)httpExchange.getResponseEncoding());
        InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientIn);
        phaseOut.doIntercept(msg);
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase) {
        InterceptorChain chain = this.binding.getInterceptorChain(phase);
        if (this.policies != null) {
            for (int i = 0; i < this.policies.length; ++i) {
                chain.add((Iterable)this.policies[i].getInterceptors(phase));
            }
        }
        return chain;
    }
}

