/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import java.io.InputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.http.endpoints.HttpConsumerEndpoint;
import org.apache.servicemix.http.endpoints.HttpSoapConsumerMarshaler;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.wsdl.BindingFactory;
import org.apache.servicemix.soap.wsdl.WSDLUtils;
import org.apache.servicemix.soap.wsdl.validator.WSIBPValidator;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;

public class HttpSoapConsumerEndpoint
extends HttpConsumerEndpoint {
    private Resource wsdl;
    private boolean useJbiWrapper = true;
    private boolean validateWsdl = true;
    private Policy[] policies;

    public HttpSoapConsumerEndpoint() {
    }

    public HttpSoapConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpSoapConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public Resource getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public boolean isValidateWsdl() {
        return this.validateWsdl;
    }

    public void setValidateWsdl(boolean validateWsdl) {
        this.validateWsdl = validateWsdl;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    public void validate() throws DeploymentException {
        HttpSoapConsumerMarshaler marshaler;
        if (this.wsdl == null) {
            throw new DeploymentException("wsdl property must be set");
        }
        if (this.getMarshaler() instanceof HttpSoapConsumerMarshaler) {
            marshaler = (HttpSoapConsumerMarshaler)this.getMarshaler();
        } else if (this.getMarshaler() == null) {
            marshaler = new HttpSoapConsumerMarshaler();
        } else {
            throw new DeploymentException("The configured marshaler must inherit HttpSoapConsumerMarshaler");
        }
        try {
            this.description = DomUtil.parse((InputStream)this.wsdl.getInputStream());
            Element elem = this.description.getDocumentElement();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(elem.getNamespaceURI())) {
                this.validateWsdl1(marshaler);
            } else if ("http://www.w3.org/2006/01/wsdl".equals(elem.getNamespaceURI())) {
                this.validateWsdl2(marshaler);
            } else {
                throw new DeploymentException("Unrecognized wsdl namespace: " + elem.getNamespaceURI());
            }
            marshaler.setUseJbiWrapper(this.useJbiWrapper);
            marshaler.setPolicies(this.policies);
            this.setMarshaler(marshaler);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to read WSDL from: " + this.wsdl, (Throwable)e);
        }
        if (this.getTargetService() == null && this.getTargetInterface() == null && this.getTargetUri() == null) {
            this.setTargetService(this.getService());
            this.setTargetEndpoint(this.getEndpoint());
        }
        super.validate();
    }

    private void validateWsdl2(HttpSoapConsumerMarshaler marshaler) throws org.apache.woden.WSDLException, IOException, DeploymentException {
        Endpoint endpoint;
        Service svc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        DescriptionElement descElement = reader.readWSDL(this.wsdl.getURL().toString());
        Description desc = descElement.toComponent();
        if (this.getService() != null) {
            svc = desc.getService(this.getService());
            if (svc == null) {
                throw new DeploymentException("Could not find service '" + this.getService() + "' in wsdl");
            }
        } else if (desc.getServices().length == 1) {
            svc = desc.getServices()[0];
            this.setService(svc.getName());
        } else {
            throw new DeploymentException("If service is not set, the WSDL must contain a single service definition");
        }
        if (this.getEndpoint() != null) {
            endpoint = svc.getEndpoint(new NCName(this.getEndpoint()));
            if (endpoint == null) {
                throw new DeploymentException("Cound not find endpoint '" + this.getEndpoint() + "' in wsdl for service '" + this.getService() + "'");
            }
        } else if (svc.getEndpoints().length == 1) {
            endpoint = svc.getEndpoints()[0];
            this.setEndpoint(endpoint.getName().toString());
        } else {
            throw new DeploymentException("If endpoint is not set, the WSDL service '" + this.getService() + "' must contain a single port definition");
        }
        marshaler.setBinding(BindingFactory.createBinding((Endpoint)endpoint));
    }

    private void validateWsdl1(HttpSoapConsumerMarshaler marshaler) throws WSDLException, IOException, DeploymentException {
        SOAPAddress soapAddress;
        Port port;
        javax.wsdl.Service svc;
        WSIBPValidator validator;
        Definition def = WSDLUtils.createWSDL11Reader().readWSDL(this.wsdl.getURL().toString());
        if (this.validateWsdl && !(validator = new WSIBPValidator(def)).isValid()) {
            throw new DeploymentException("WSDL is not WS-I BP compliant: " + validator.getErrors());
        }
        if (this.getService() != null) {
            svc = def.getService(this.getService());
            if (svc == null) {
                throw new DeploymentException("Could not find service '" + this.getService() + "' in wsdl");
            }
        } else if (def.getServices().size() == 1) {
            svc = (javax.wsdl.Service)def.getServices().values().iterator().next();
            this.setService(svc.getQName());
        } else {
            throw new DeploymentException("If service is not set, the WSDL must contain a single service definition");
        }
        if (this.getEndpoint() != null) {
            port = svc.getPort(this.getEndpoint());
            if (port == null) {
                throw new DeploymentException("Cound not find port '" + this.getEndpoint() + "' in wsdl for service '" + this.getService() + "'");
            }
        } else if (svc.getPorts().size() == 1) {
            port = (Port)svc.getPorts().values().iterator().next();
            this.setEndpoint(port.getName());
        } else {
            throw new DeploymentException("If endpoint is not set, the WSDL service '" + this.getService() + "' must contain a single port definition");
        }
        if ((soapAddress = (SOAPAddress)WSDLUtils.getExtension((ElementExtensible)port, SOAPAddress.class)) != null) {
            soapAddress.setLocationURI(this.getLocationURI());
        } else {
            SOAP12Address soap12Address = (SOAP12Address)WSDLUtils.getExtension((ElementExtensible)port, SOAP12Address.class);
            if (soap12Address != null) {
                soap12Address.setLocationURI(this.getLocationURI());
            }
        }
        this.description = WSDLUtils.getWSDL11Factory().newWSDLWriter().getDocument(def);
        marshaler.setBinding(BindingFactory.createBinding((Port)port));
    }

    protected void loadStaticResources() {
        this.addResource("main.wsdl", this.description);
    }
}

