/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.endpoints.DefaultHttpProviderMarshaler;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

public class HttpProviderEndpoint
extends ProviderEndpoint
implements HttpEndpointType {
    private HttpProviderMarshaler marshaler;
    private String locationURI;
    private int clientSoTimeout = 10000;
    private HttpClient jettyClient;

    public HttpProviderEndpoint() {
    }

    public HttpProviderEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public HttpProviderMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpProviderMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            NormalizedMessage nm = exchange.getMessage("in");
            if (nm == null) {
                throw new IllegalStateException("Exchange has no input message");
            }
            Exchange httpEx = new Exchange(exchange);
            this.marshaler.createRequest(exchange, nm, httpEx);
            this.getConnectionPool().send((HttpExchange)httpEx);
        }
    }

    protected void handle(SmxHttpExchange httpExchange, MessageExchange exchange) throws IOException {
        try {
            boolean txSync;
            this.marshaler.handleResponse(exchange, httpExchange);
            boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    protected void handleConnectionFailed(Throwable throwable, MessageExchange exchange) {
        try {
            Exception e = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            exchange.setError(e);
            this.send(exchange);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to send back exchange in error", (Throwable)e);
        }
    }

    protected HttpClient getConnectionPool() throws Exception {
        if (this.jettyClient == null) {
            HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
            this.jettyClient = comp.getConfiguration().isJettyClientPerProvider() ? comp.getNewJettyClient(comp) : comp.getConnectionPool();
            this.jettyClient.setSoTimeout(this.getClientSoTimeout());
        }
        return this.jettyClient;
    }

    public int getClientSoTimeout() {
        return this.clientSoTimeout;
    }

    public void setClientSoTimeout(int clientTimeout) {
        this.clientSoTimeout = clientTimeout;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.marshaler == null) {
            this.marshaler = new DefaultHttpProviderMarshaler();
        }
        if (this.marshaler instanceof DefaultHttpProviderMarshaler && this.locationURI != null) {
            ((DefaultHttpProviderMarshaler)this.marshaler).setLocationURI(this.locationURI);
        }
    }

    protected class Exchange
    extends SmxHttpExchange {
        MessageExchange jbiExchange;

        public Exchange(MessageExchange jbiExchange) {
            this.jbiExchange = jbiExchange;
        }

        protected void onResponseComplete() throws IOException {
            HttpProviderEndpoint.this.handle(this, this.jbiExchange);
        }

        protected void onException(Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }

        protected void onConnectionFailed(Throwable throwable) {
            HttpProviderEndpoint.this.handleConnectionFailed(throwable, this.jbiExchange);
        }
    }
}

