/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import java.security.Security;

public class SslParameters {
    private boolean managed;
    private String keyAlias;
    private String keyPassword;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType = "JKS";
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType = "JKS";
    private String protocol = "TLS";
    private String keyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String trustManagerFactoryAlgorithm;
    private String provider;
    private boolean wantClientAuth;
    private boolean needClientAuth;

    public SslParameters() {
        if (this.keyManagerFactoryAlgorithm == null) {
            this.keyManagerFactoryAlgorithm = "IBM Corporation".equals(System.getProperty("java.vendor")) ? "IbmX509" : "SunX509";
        }
        this.trustManagerFactoryAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm");
        if (this.trustManagerFactoryAlgorithm == null) {
            this.trustManagerFactoryAlgorithm = "IBM Corporation".equals(System.getProperty("java.vendor")) ? "PKIX" : "SunX509";
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String algorithm) {
        this.keyManagerFactoryAlgorithm = algorithm;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }

    public void setTrustManagerFactoryAlgorithm(String algorithm) {
        this.trustManagerFactoryAlgorithm = algorithm;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SslParameters)) {
            return false;
        }
        SslParameters s = (SslParameters)o;
        return this.managed == s.managed && SslParameters.eq(this.keyAlias, s.keyAlias) && SslParameters.eq(this.keyManagerFactoryAlgorithm, s.keyManagerFactoryAlgorithm) && SslParameters.eq(this.trustManagerFactoryAlgorithm, s.trustManagerFactoryAlgorithm) && SslParameters.eq(this.keyPassword, s.keyPassword) && SslParameters.eq(this.keyStore, s.keyStore) && SslParameters.eq(this.keyStorePassword, s.keyStorePassword) && SslParameters.eq(this.keyStoreType, s.keyStoreType) && this.needClientAuth == s.needClientAuth && SslParameters.eq(this.protocol, s.protocol) && SslParameters.eq(this.trustStore, s.trustStore) && SslParameters.eq(this.trustStorePassword, s.trustStorePassword) && SslParameters.eq(this.trustStoreType, s.trustStoreType) && this.wantClientAuth == s.wantClientAuth;
    }

    public int hashCode() {
        return Boolean.valueOf(this.managed).hashCode() ^ Boolean.valueOf(this.needClientAuth).hashCode() ^ Boolean.valueOf(this.wantClientAuth).hashCode() ^ SslParameters.hash(new String[]{this.keyAlias, this.keyManagerFactoryAlgorithm, this.trustManagerFactoryAlgorithm, this.keyPassword, this.keyStore, this.keyStorePassword, this.keyStoreType, this.protocol, this.trustStore, this.trustStorePassword, this.trustStoreType});
    }

    private static boolean eq(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private static int hash(String[] strings) {
        int result = 0;
        for (String s : strings) {
            result ^= SslParameters.hash(s);
        }
        return result;
    }

    private static int hash(String s) {
        return s != null ? s.hashCode() : 0;
    }
}

