/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpConfiguration;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.SslParameters;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

public class ManagedContextManager
implements ContextManager {
    private HttpConfiguration configuration;
    private Map managedContexts;

    public void init() throws Exception {
        if (this.configuration == null) {
            this.configuration = new HttpConfiguration();
        }
        this.managedContexts = new ConcurrentHashMap();
    }

    public void shutDown() throws Exception {
        this.stop();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized Object createContext(String strUrl, HttpProcessor processor) throws Exception {
        URI uri = new URI(strUrl);
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = path + "/";
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.managedContexts.put(path, processor);
        return path;
    }

    public synchronized void remove(Object context) throws Exception {
        this.managedContexts.remove(context);
    }

    public HttpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpConfiguration configuration) {
        this.configuration = configuration;
    }

    public HttpProcessor getMainProcessor() {
        if (!this.configuration.isManaged()) {
            throw new IllegalStateException("ServerManager is not managed");
        }
        return new MainProcessor();
    }

    protected class MainProcessor
    implements HttpProcessor {
        private String mapping;

        public MainProcessor() {
            this.mapping = ManagedContextManager.this.configuration.getMapping();
        }

        public String getAuthMethod() {
            return null;
        }

        public SslParameters getSsl() {
            return null;
        }

        public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
            String uri = request.getRequestURI();
            if ("/".equals(uri) && "GET".equals(request.getMethod())) {
                this.displayServices(request, response);
                return;
            }
            Set urls = ManagedContextManager.this.managedContexts.keySet();
            for (String url : urls) {
                if (!uri.startsWith(request.getContextPath() + this.mapping + url)) continue;
                HttpProcessor proc = (HttpProcessor)ManagedContextManager.this.managedContexts.get(url);
                proc.process(request, response);
                return;
            }
            this.displayServices(request, response);
        }

        public void displayServices(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setStatus(404);
            response.setContentType("text/html");
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
            String uri = request.getRequestURI();
            uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
            uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
            writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
            writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
            writer.write("No service matched or handled this request.<BR>");
            writer.write("Known services are: <ul>");
            Set servers = ManagedContextManager.this.managedContexts.keySet();
            for (String context : servers) {
                if (!context.endsWith("/")) {
                    context = context + "/";
                }
                String protocol = request.isSecure() ? "https" : "http";
                context = protocol + "://" + request.getLocalName() + ":" + request.getLocalPort() + request.getContextPath() + this.mapping + context;
                writer.write("<li><a href=\"");
                writer.write(context);
                writer.write("?wsdl\">");
                writer.write(context);
                writer.write("</a></li>\n");
            }
            for (int i = 0; i < 10; ++i) {
                writer.write("\n<!-- Padding for IE                  -->");
            }
            writer.write("\n</BODY>\n</HTML>\n");
            writer.flush();
            response.setContentLength(writer.size());
            ServletOutputStream out = response.getOutputStream();
            writer.writeTo((OutputStream)out);
            out.close();
        }
    }
}

