/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpEventListenerWrapper;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.BasicAuthorization;
import org.mortbay.jetty.client.security.DigestAuthorization;
import org.mortbay.jetty.client.security.Realm;
import org.mortbay.jetty.client.security.RealmResolver;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityListener
extends HttpEventListenerWrapper {
    private HttpDestination _destination;
    private HttpExchange _exchange;
    private int _attempts = 0;

    public SecurityListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._destination = destination;
        this._exchange = ex;
    }

    protected String scrapeAuthenticationType(String authString) {
        String authType;
        if (authString.indexOf(" ") == -1) {
            authType = authString.toString().trim();
        } else {
            String authResponse = authString.toString();
            authType = authResponse.substring(0, authResponse.indexOf(" ")).trim();
        }
        return authType;
    }

    protected Map<String, String> scrapeAuthenticationDetails(String authString) {
        HashMap<String, String> authenticationDetails = new HashMap<String, String>();
        authString = authString.substring(authString.indexOf(" ") + 1, authString.length());
        StringTokenizer strtok = new StringTokenizer(authString, ",");
        while (strtok.hasMoreTokens()) {
            String[] pair = strtok.nextToken().split("=");
            if (pair.length == 2) {
                String itemName = pair[0].trim();
                String itemValue = pair[1].trim();
                itemValue = StringUtil.unquote((String)itemValue);
                authenticationDetails.put(itemName, itemValue);
                continue;
            }
            throw new IllegalArgumentException("unable to process authentication details");
        }
        return authenticationDetails;
    }

    @Override
    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("SecurityListener:Response Status: " + status));
        }
        if (status == 401 && this._attempts < this._destination.getHttpClient().maxRetries()) {
            this.setDelegating(false);
        } else {
            this.setDelegating(true);
        }
        super.onResponseStatus(version, status, reason);
    }

    @Override
    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("SecurityListener:Header: " + name.toString() + " / " + value.toString()));
        }
        if (!this.isDelegating()) {
            int header = HttpHeaders.CACHE.getOrdinal(name);
            switch (header) {
                case 51: {
                    String authString = value.toString();
                    String type = this.scrapeAuthenticationType(authString);
                    Map<String, String> details = this.scrapeAuthenticationDetails(authString);
                    String pathSpec = "/";
                    RealmResolver realmResolver = this._destination.getHttpClient().getRealmResolver();
                    if (realmResolver == null) break;
                    Realm realm = realmResolver.getRealm(details.get("realm"), this._destination, pathSpec);
                    if (realm == null) {
                        Log.warn((String)("Unknown Security Realm: " + details.get("realm")));
                        break;
                    }
                    if ("digest".equalsIgnoreCase(type)) {
                        this._destination.addAuthorization("/", new DigestAuthorization(realm, details));
                        break;
                    }
                    if (!"basic".equalsIgnoreCase(type)) break;
                    this._destination.addAuthorization(pathSpec, new BasicAuthorization(realm));
                }
            }
        }
        super.onResponseHeader(name, value);
    }

    @Override
    public void onResponseComplete() throws IOException {
        if (!this.isDelegating()) {
            this._destination.resend(this._exchange);
        } else {
            super.onResponseComplete();
        }
    }

    @Override
    public void onRetry() {
        ++this._attempts;
        this.setDelegating(true);
        super.onRetry();
    }
}

