/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.client.HttpExchange;

public class CachedExchange
extends HttpExchange {
    int _responseStatus;
    HttpFields _responseFields;

    public CachedExchange(boolean cacheFields) {
        if (cacheFields) {
            this._responseFields = new HttpFields();
        }
    }

    public int getResponseStatus() {
        if (this._status < 5) {
            throw new IllegalStateException("Response not received");
        }
        return this._responseStatus;
    }

    public HttpFields getResponseFields() {
        if (this._status < 6) {
            throw new IllegalStateException("Headers not complete");
        }
        return this._responseFields;
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        this._responseStatus = status;
        super.onResponseStatus(version, status, reason);
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._responseFields != null) {
            this._responseFields.add(name, value);
        }
        super.onResponseHeader(name, value);
    }
}

