/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import java.io.Serializable;
import java.util.Date;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.eip.support.AbstractAggregator;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SplitAggregator
extends AbstractAggregator {
    protected Expression count = new PropertyExpression("org.apache.servicemix.eip.splitter.count");
    protected Expression index = new PropertyExpression("org.apache.servicemix.eip.splitter.index");
    protected Expression corrId = new PropertyExpression("org.apache.servicemix.eip.splitter.corrid");
    protected QName aggregateElementName = new QName("aggregate");
    protected QName messageElementName = new QName("message");
    protected String countAttribute = "count";
    protected String indexAttribute = "index";
    protected long timeout;

    public QName getAggregateElementName() {
        return this.aggregateElementName;
    }

    public void setAggregateElementName(QName aggregateElementName) {
        this.aggregateElementName = aggregateElementName;
    }

    public Expression getCorrId() {
        return this.corrId;
    }

    public void setCorrId(Expression corrId) {
        this.corrId = corrId;
    }

    public Expression getCount() {
        return this.count;
    }

    public void setCount(Expression count) {
        this.count = count;
    }

    public String getCountAttribute() {
        return this.countAttribute;
    }

    public void setCountAttribute(String countAttribute) {
        this.countAttribute = countAttribute;
    }

    public Expression getIndex() {
        return this.index;
    }

    public void setIndex(Expression index) {
        this.index = index;
    }

    public String getIndexAttribute() {
        return this.indexAttribute;
    }

    public void setIndexAttribute(String indexAttribute) {
        this.indexAttribute = indexAttribute;
    }

    public QName getMessageElementName() {
        return this.messageElementName;
    }

    public void setMessageElementName(QName messageElementName) {
        this.messageElementName = messageElementName;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Object createAggregation(String correlationID) {
        return new SplitterAggregation(correlationID);
    }

    public String getCorrelationID(MessageExchange exchange, NormalizedMessage message) throws Exception {
        return (String)this.corrId.evaluate(exchange, message);
    }

    public boolean addMessage(Object aggregation, NormalizedMessage message, MessageExchange exchange) throws Exception {
        NormalizedMessage[] messages = ((SplitterAggregation)aggregation).messages;
        Integer cnt = (Integer)this.count.evaluate(exchange, message);
        if (cnt == null) {
            throw new IllegalArgumentException("Property org.apache.servicemix.eip.splitter.count not specified on message");
        }
        if (messages == null) {
            ((SplitterAggregation)aggregation).messages = messages = new NormalizedMessage[cnt.intValue()];
        } else if (cnt != messages.length) {
            throw new IllegalArgumentException("Property org.apache.servicemix.eip.splitter.count is not consistent (received " + cnt + ", was " + messages.length + ")");
        }
        Integer idx = (Integer)this.index.evaluate(exchange, message);
        if (idx == null) {
            throw new IllegalArgumentException("Property org.apache.servicemix.eip.splitter.index not specified on message");
        }
        if (idx < 0 || idx >= messages.length) {
            throw new IllegalArgumentException("Index is ouf of bound: " + idx + " [0.." + messages.length + "]");
        }
        if (messages[idx] != null) {
            throw new IllegalStateException("Message with index " + idx + " has already been received");
        }
        messages[idx.intValue()] = message;
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i] != null) continue;
            return false;
        }
        return true;
    }

    public void buildAggregate(Object aggregation, NormalizedMessage message, MessageExchange exchange, boolean doTimeout) throws Exception {
        NormalizedMessage[] messages = ((SplitterAggregation)aggregation).messages;
        String correlationId = ((SplitterAggregation)aggregation).correlationId;
        SourceTransformer st = new SourceTransformer();
        Document doc = st.createDocument();
        Element root = this.createChildElement(this.aggregateElementName, doc);
        root.setAttribute(this.countAttribute, Integer.toString(messages.length));
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i] == null) continue;
            Element elem = st.toDOMElement(messages[i]);
            if (this.messageElementName != null) {
                Element msg = this.createChildElement(this.messageElementName, root);
                msg.setAttribute(this.indexAttribute, Integer.toString(i));
                msg.appendChild(doc.importNode(elem, true));
                continue;
            }
            root.appendChild(doc.importNode(elem, true));
        }
        message.setContent((Source)new DOMSource(doc));
        message.setProperty("org.apache.servicemix.eip.splitter.corrid", (Object)correlationId);
    }

    protected Element createChildElement(QName name, Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element elem = "".equals(name.getNamespaceURI()) ? doc.createElement(name.getLocalPart()) : doc.createElementNS(name.getNamespaceURI(), name.getPrefix() + ":" + name.getLocalPart());
        parent.appendChild(elem);
        return elem;
    }

    public Date getTimeout(Object aggregation) {
        if (this.timeout > 0L) {
            return new Date(System.currentTimeMillis() + this.timeout);
        }
        return null;
    }

    protected static class SplitterAggregation
    implements Serializable {
        private static final long serialVersionUID = 8555934895155403923L;
        protected NormalizedMessage[] messages;
        protected String correlationId;

        public SplitterAggregation(String correlationId) {
            this.correlationId = correlationId;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        public NormalizedMessage[] getMessages() {
            return this.messages;
        }

        public void setMessages(NormalizedMessage[] messages) {
            this.messages = messages;
        }
    }
}

