/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.resource.ResourceManager;
import org.xml.sax.InputSource;

public class ResourceManagerWSDLLocator
implements WSDLLocator {
    WSDLLocator parent;
    Bus bus;
    String wsdlUrl;
    InputSource last;
    String baseUri;
    boolean fromParent;

    public ResourceManagerWSDLLocator(String wsdlUrl, WSDLLocator parent, Bus bus) {
        this.wsdlUrl = wsdlUrl;
        this.bus = bus;
        this.parent = parent;
    }

    public ResourceManagerWSDLLocator(String wsdlUrl, Bus bus) {
        this.wsdlUrl = wsdlUrl;
        this.bus = bus;
        this.parent = new CatalogWSDLLocator(wsdlUrl, OASISCatalogManager.getCatalogManager(bus));
    }

    public void close() {
        if (!this.fromParent) {
            try {
                if (this.last.getByteStream() != null) {
                    this.last.getByteStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.parent.close();
    }

    public InputSource getBaseInputSource() {
        InputSource is = this.parent.getBaseInputSource();
        this.fromParent = true;
        if (is == null) {
            InputStream ins = ((ResourceManager)this.bus.getExtension(ResourceManager.class)).getResourceAsStream(this.wsdlUrl);
            is = new InputSource(ins);
            is.setSystemId(this.wsdlUrl);
            is.setPublicId(this.wsdlUrl);
            URL url = (URL)((ResourceManager)this.bus.getExtension(ResourceManager.class)).resolveResource(this.wsdlUrl, URL.class);
            if (url != null) {
                is.setSystemId(url.toString());
                is.setPublicId(url.toString());
            }
            this.fromParent = false;
            this.baseUri = is.getPublicId();
        } else {
            this.baseUri = is.getSystemId();
        }
        this.last = is;
        return is;
    }

    public String getBaseURI() {
        if (this.last == null) {
            this.getBaseInputSource();
            try {
                if (this.last.getByteStream() != null) {
                    this.last.getByteStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.baseUri;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        return this.parent.getImportInputSource(parentLocation, importLocation);
    }

    public String getLatestImportURI() {
        return this.parent.getLatestImportURI();
    }
}

