/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConduitInitiatorManagerImpl
implements ConduitInitiatorManager {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ConduitInitiatorManager.class);
    final Map<String, ConduitInitiator> conduitInitiators;
    private Bus bus;

    public ConduitInitiatorManagerImpl() {
        this.conduitInitiators = new ConcurrentHashMap<String, ConduitInitiator>();
    }

    public ConduitInitiatorManagerImpl(MapProvider<String, ConduitInitiator> conduitInitiators) {
        this.conduitInitiators = conduitInitiators.createMap();
    }

    public ConduitInitiatorManagerImpl(Map<String, ConduitInitiator> conduitInitiators) {
        this.conduitInitiators = conduitInitiators;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, ConduitInitiatorManager.class);
        }
    }

    public void registerConduitInitiator(String namespace, ConduitInitiator factory) {
        this.conduitInitiators.put(namespace, factory);
    }

    public void deregisterConduitInitiator(String namespace) {
        this.conduitInitiators.remove(namespace);
    }

    public ConduitInitiator getConduitInitiator(String namespace) throws BusException {
        ConduitInitiator factory = this.conduitInitiators.get(namespace);
        if (null == factory) {
            throw new BusException(new Message("NO_CONDUIT_INITIATOR", BUNDLE, new Object[]{namespace}));
        }
        return factory;
    }

    @PreDestroy
    public void shutdown() {
    }

    public ConduitInitiator getConduitInitiatorForUri(String uri) {
        return null;
    }
}

