/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class AttachmentSerializer {
    private static final String BODY_ATTACHMENT_ID = "root.message@cxf.apache.org";
    private Message message;
    private String bodyBoundary;
    private OutputStream out;
    private String encoding;
    private boolean xop = true;

    public AttachmentSerializer(Message messageParam) {
        this.message = messageParam;
    }

    public void writeProlog() throws IOException {
        String enc;
        this.bodyBoundary = AttachmentUtil.getUniqueBoundaryValue(0);
        String bodyCt = (String)this.message.get((Object)"Content-Type");
        if ((bodyCt = bodyCt.replaceAll("\"", "\\\"")).indexOf(34) != -1 && bodyCt.indexOf(59) != -1) {
            int pos = bodyCt.indexOf(59);
            StringBuffer st = new StringBuffer(bodyCt.substring(0, pos));
            st.append("\"").append(bodyCt.substring(pos, bodyCt.length() - 1));
            bodyCt = st.toString();
        }
        if ((enc = (String)this.message.get((Object)Message.ENCODING)) == null) {
            enc = "UTF-8";
        }
        StringBuilder ct = new StringBuilder();
        ct.append("multipart/related; ");
        if (this.xop) {
            ct.append("type=\"application/xop+xml\"; ");
        }
        ct.append("boundary=\"").append(this.bodyBoundary).append("\"; ").append("start=\"<").append(BODY_ATTACHMENT_ID).append(">\"; ").append("start-info=\"").append(bodyCt).append("\"");
        this.message.put((Object)"Content-Type", (Object)ct.toString());
        this.out = (OutputStream)this.message.getContent(OutputStream.class);
        this.encoding = (String)this.message.get((Object)Message.ENCODING);
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        StringWriter writer = new StringWriter();
        writer.write("\r\n");
        writer.write("--");
        writer.write(this.bodyBoundary);
        StringBuilder mimeBodyCt = new StringBuilder();
        mimeBodyCt.append("application/xop+xml; charset=").append(enc).append("; type=\"").append(bodyCt).append("\";");
        this.writeHeaders(mimeBodyCt.toString(), BODY_ATTACHMENT_ID, writer);
        this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
    }

    private void writeHeaders(String contentType, String attachmentId, Writer writer) throws IOException {
        writer.write("\r\n");
        writer.write("Content-Type: ");
        writer.write(contentType);
        writer.write("\r\n");
        writer.write("Content-Transfer-Encoding: binary\r\n");
        writer.write("Content-ID: <");
        writer.write(attachmentId);
        writer.write(">\r\n\r\n");
    }

    public void writeAttachments() throws IOException {
        if (this.message.getAttachments() != null) {
            for (Attachment a : this.message.getAttachments()) {
                StringWriter writer = new StringWriter();
                writer.write("\r\n");
                writer.write("--");
                writer.write(this.bodyBoundary);
                this.writeHeaders(a.getDataHandler().getContentType(), a.getId(), writer);
                this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
                a.getDataHandler().writeTo(this.out);
            }
        }
        StringWriter writer = new StringWriter();
        writer.write("\r\n");
        writer.write("--");
        writer.write(this.bodyBoundary);
        writer.write("--");
        this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
        this.out.flush();
    }

    public boolean isXop() {
        return this.xop;
    }

    public void setXop(boolean xop) {
        this.xop = xop;
    }
}

