package model
{
	import mx.collections.ArrayCollection;
	
	[Bindable]
	public class State
	{
		
		public static const TRANSIENT:String = "transient";
		public static const INITIAL_FINAL:String = "initial-final";
		public static const FINAL:String = "final";
		
		private var _isTarget:Boolean = false;
		
		public var label:String;
		
		private var _tipology:String = "";
		
		private var _name:String = "";
		
		
		
		//collection di transition
		public var transitionList:ArrayCollection;
		
		private function updateLabel():void
		{
			if(!_isTarget)
				label = "State: "+_name+" - Tipology: "+_tipology;
			else
				label = "Target state: "+_name;
		}
		
		public function set isTarget(b:Boolean):void
		{
			_isTarget = b;
			updateLabel();
		}
		
		public function get isTarget():Boolean
		{
			return _isTarget;
		}

		public function set name(s:String):void
		{
			_name = s;
			updateLabel();
		}		
		
		public function get name():String
		{
			return _name;
		}
		
		public function set tipology(t:String):void
		{
			_tipology = t;
			updateLabel();
		}
		
		public function get tipology():String
		{
			return _tipology;
		}

	}
}