package descriptor
{
	import model.ModelLocator;
	import model.State;
	import model.Transition;
	
	import mx.collections.ICollectionView;
	import mx.controls.treeClasses.ITreeDataDescriptor;

	public class StatesDataDescriptor implements ITreeDataDescriptor
	{
		public function StatesDataDescriptor()
		{
		}

		public function getChildren(node:Object, model:Object=null):ICollectionView
		{
			if(node is State)
				return (node as State).transitionList;
			if(node is Transition)
				return (node as Transition).targetList;
				
			return null;
		}
		
		public function hasChildren(node:Object, model:Object=null):Boolean
		{
			if(node is State)
				return (node as State).transitionList.length>0;
			if(node is Transition)
				return (node as Transition).targetList.length>0;
				
			return false;
		}
		
		public function isBranch(node:Object, model:Object=null):Boolean
		{
			if(node.hasOwnProperty("isTarget") && node.isTarget)
				return false;
			else
				return true;
		}
		
		public function getData(node:Object, model:Object=null):Object
		{
			return node;
		}
		
		public function addChildAt(parent:Object, newChild:Object, index:int, model:Object=null):Boolean
		{
			return false;
		}
		
		public function removeChildAt(parent:Object, child:Object, index:int, model:Object=null):Boolean
		{
			return false;
		}
		
	}
}