package backend;

import java.util.Calendar;
import java.util.HashMap;

public class HotelBackend {

	private HashMap<Prenotazione, Boolean> map = new HashMap<Prenotazione, Boolean>();
	
	private static HotelBackend instance = null;
	
	public static HotelBackend getInstance() {
		if(instance == null)
			instance = new HotelBackend();
		
		return instance;
	}
	
	private HotelBackend() {
		
	}
	
	public boolean controlla(Calendar data) {

		Prenotazione p = new Prenotazione();
		p.data = data;
		p.stanza = 1;
		while(p.stanza <= 10) {
			if(map.get(p)==null || !map.get(p).booleanValue())
				return true;
			else
				p.stanza++;
		}
		
		return false;
			
	}
	
	
	public int prenota(Calendar data) {
		
		Prenotazione p = new Prenotazione();
		p.data = data;
		p.stanza = 1;
		
		while(p.stanza <= 10) {
			if(map.get(p)==null || !map.get(p).booleanValue()) {
				map.put(p, new Boolean(true));
				return p.stanza;
			}
			else
				p.stanza++;
		}
		
		return 0;
	}
			
	
	
	
}

class Prenotazione {
	public int stanza;
	public Calendar data;
	@Override
	
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((data == null) ? 0 : data.hashCode());
		result = prime * result + stanza;
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Prenotazione other = (Prenotazione) obj;
		if (data == null) {
			if (other.data != null)
				return false;
		} else if (!data.equals(other.data))
			return false;
		if (stanza != other.stanza)
			return false;
		return true;
	}
}