package backend;

import java.util.Calendar;
import java.util.HashMap;

public class CompagniaAereaBackend {

	
	private HashMap<PrenotazioneAerea, Boolean> map = new HashMap<PrenotazioneAerea, Boolean>();
	
	private static CompagniaAereaBackend instance = null;
	
	public static CompagniaAereaBackend getInstance() {
		if(instance == null)
			instance = new CompagniaAereaBackend();
		
		return instance;
	}
	
	private CompagniaAereaBackend() {
		
	}
	
	public boolean controlla(Calendar data) {

		PrenotazioneAerea p = new PrenotazioneAerea();
		p.data = data;
		p.posto = 1;
		while(p.posto <= 100) {
			if(map.get(p)==null || !map.get(p).booleanValue())
				return true;
			else
				p.posto++;
		}
		
		return false;
			
	}
	
	
	public int prenota(Calendar data) {
		 
		PrenotazioneAerea p = new PrenotazioneAerea();
		p.data = data;
		p.posto = 1;
		
		while(p.posto <= 100) {
			if(map.get(p)==null || !map.get(p).booleanValue()) {
				map.put(p, new Boolean(true));
				return p.posto;
			}
			else
				p.posto++;
		}
		
		return 0;
	}
			
	
	
	
}

class PrenotazioneAerea {
	public int posto;
	public Calendar data;
	@Override
	
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((data == null) ? 0 : data.hashCode());
		result = prime * result + posto;
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PrenotazioneAerea other = (PrenotazioneAerea) obj;
		if (data == null) {
			if (other.data != null)
				return false;
		} else if (!data.equals(other.data))
			return false;
		if (posto != other.posto)
			return false;
		return true;
	}

}
