package backend;

import java.util.HashMap;

public class BancaBackend {

private HashMap<String, Double> map = new HashMap<String, Double>();
	
	private static BancaBackend instance = null;
	
	public static BancaBackend getInstance() {
		if(instance == null)
			instance = new BancaBackend();
		
		return instance;
	}
	
	private BancaBackend() {
		map.put("123456789", new Double(10000.00d));
		map.put("987654321", new Double(1000.00d));
	}
	
	public boolean controllaDisponibilita(String numero, double importo) {

		if(map.get(numero)!=null) {
			return map.get(numero).doubleValue()>importo;
		} else {
			return false;
		}
			
	}
	
	
	public boolean paga(String numero, double importo) {
		
		if(controllaDisponibilita(numero, importo)){
			map.put(numero, map.get(numero)-importo);
			return true;
		}
		else
			return false;
	}
			
	
	
	
}

	

