/**
 * 
 */
package wsce;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.dis.uniroma1.swsce.composition.TestComp;

import util.Config;
import util.ServerMessages;

/**
 *
 */
public class WSCEGenerator {
	private static Logger logger = Logger.getLogger(WSCEGenerator.class.getName());
	 
	/**
	 * 
	 */
	public WSCEGenerator() {
		super();
	}
	
	/**
	 * @param wstsl
	 * @return
	 */
	public String createTarget(String wstsl) {
		if ((wstsl == null) || (wstsl.length() == 0))
			return ServerMessages.ERROR_PARAMETER;
		
		try {
//			WSCERunner runner = new WSCERunner(Config.PREFIX + Config.DIR_COMPOSIZIONI + File.separator + wstsl);
//			WSCERunner runner = new WSCERunner(wstsl);
//			int exitCode = runner.start();
//			runner.join();
			String[] args = {Config.getInstance().getProperty(Config.PREFIX) + File.separator + Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI), wstsl, Config.getInstance().getProperty(Config.SHELL) + " " + Config.getInstance().getProperty(Config.SHELL_PARAMETERS)};
			int exitCode = TestComp.executeWSCE(args);
			if (exitCode == 0)
				return ServerMessages.MESSAGE_CREATED;
			else
				return ServerMessages.ERROR_CREATED;
		} catch (Exception e) {
			logger.log(Level.SEVERE, "createTarget", e);
			return ServerMessages.ERROR_CREATED;
		}
	}
	
	/**
	 * @return
	 */
	public String[] getNewWSTSL() {
		ArrayList<String> list = new ArrayList<String>();
		try {
			File composizioni = new File(Config.getInstance().getProperty(Config.PREFIX) + File.separator + Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI));
			logger.info(composizioni.getPath());
			File[] dirs = composizioni.listFiles();
			for (File dir : dirs) {
				logger.info(dir.getPath());
				if (dir.isDirectory()) {
					File[] content = dir.listFiles();
					
					boolean isGenerated = false;
					for (File f : content) {
						if (!f.getName().startsWith(".") && f.getName().equalsIgnoreCase(Config.getInstance().getProperty(Config.DB_COMPOSITION_FILE))) {
							isGenerated = true;
							break;
						}
					}
					
					if (!isGenerated)
						list.add(dir.getName());
				}
			}
			
			return list.toArray(new String[list.size()]);
		} catch (Exception e) {
			e.printStackTrace();
			logger.severe("getNewWSTSL " + e.getMessage());
			return new String[0];
		}
	}
}
