package util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/**
 * Servlet implementation class UploadServlet
 */
public class UploadServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private static int LENGHT = 4096000;
	
	private static String WSTSL = "wstsl";
	private static String WSDL = "wsdl";
	private static String WSDD = "wsdd";
	private static String JAR_LIB = "jar";
	
	private Logger logger = Logger.getLogger(getClass().getName());
	
    /**
     * @see HttpServlet#HttpServlet()
     */
    public UploadServlet() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doProcess(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doProcess(request, response);
	}
  	   	

	protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  
		
		
		try {
			
			String workingDir = request.getParameter("workingDir");
			String fileType = request.getParameter("fileType");
			String isTarget = request.getParameter("isTarget");
			
			if(fileType==null || fileType == "")
			{
				logger.severe("il parametro fileType  obbligatorio");
				throw new RuntimeException("il parametro fileType  obbligatorio");
			}
			
			if(fileType != JAR_LIB && (workingDir == null || workingDir == ""))
			{
				logger.severe("il parametro workingDir  obbligatorio se non si sta effettuando l'upload di un file jar");
				throw new RuntimeException("il parametro workingDir  obbligatorio se non si sta effettuando l'upload di un file jar");
			}
			
			
			String fileName = "";
			InputStream is = null;
			
			String path = "";
			
			if(fileType.equals(JAR_LIB)) {
				path = Config.getInstance().getProperty(Config.PREFIX)+File.separatorChar+"WEB-INF"+File.separatorChar+"lib";
	        } else if(fileType.equals(WSTSL) && isTarget.equals("true")) {
				path = Config.getInstance().getProperty(Config.PREFIX)+File.separatorChar+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separatorChar+workingDir+File.separatorChar+"wstsl"+File.separatorChar+"target";
	        } else if(fileType.equals(WSTSL)) {
				path = Config.getInstance().getProperty(Config.PREFIX)+File.separatorChar+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separatorChar+workingDir+File.separatorChar+"wstsl";
	        } else if(fileType.equals(WSDL)) {
				path = Config.getInstance().getProperty(Config.PREFIX)+File.separatorChar+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separatorChar+workingDir+File.separatorChar+"wsdl";
	        } else if(fileType.equals(WSDD)) {
				path = Config.getInstance().getProperty(Config.PREFIX)+File.separatorChar+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separatorChar+workingDir+File.separatorChar+"wsdd";
	        }
			
			
			logger.fine("File upload path "+path);
            DiskFileItemFactory factory = new DiskFileItemFactory(LENGHT, new File(path));
            ServletFileUpload sfu = new ServletFileUpload(factory);
            List fileItems = sfu.parseRequest(request);
            Iterator it = fileItems.iterator();
             
            while(it.hasNext()){
            	FileItem fileItem = (FileItem)it.next();
            	if(!fileItem.isFormField()) {
            		fileName = fileItem.getName();
            		
            		// quello che si aspetta WSCE nel caso si tratti del target
            		if(fileType.equals(WSTSL) && isTarget.equals("true"))
            			fileName = workingDir+".wstsl";
            		
            		is = fileItem.getInputStream();
            		fileItem.write(new File(path+File.separatorChar+fileName));
            	}
            }

            
		} catch (Exception e) {
			
			e.printStackTrace();
			logger.severe("Impossibile caricare il file::"+e.getCause());
			throw new RuntimeException(e);
		}
		
	}  

}
