package util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.jni.Directory;

/**
 * Servlet implementation class CompositionDirectoryCreator
 */
public class CompositionDirectoryCreatorServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private Logger logger = Logger.getLogger(getClass().getName());
    /**
     * @see HttpServlet#HttpServlet()
     */
    public CompositionDirectoryCreatorServlet() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doProcess(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doProcess(request, response);
	}
	
	protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  
		String workingDir = request.getParameter("workingDir");
		
		if(workingDir == null || workingDir == "")
		{
			logger.severe("il parametro workingDir  obbligatorio");
			throw new RuntimeException("il parametro workingDir  obbligatorio");
		}
		
		String path = Config.getInstance().getProperty(Config.PREFIX)+File.separatorChar+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separatorChar+workingDir;
		File file = new File(path);
		
		if(file.exists())
		{
			logger.severe("la directory di lavoro  gi presente");
			throw new RuntimeException("la directory di lavoro  gi presente");
		}
		
		file.mkdir();
		
		File txtFile = new File(file.getAbsolutePath()+File.separatorChar+workingDir+".txt");
		txtFile.createNewFile();
		
		
		File wsdd = new File(file.getAbsolutePath()+File.separatorChar+"wsdd");
		File wstsl = new File(file.getAbsolutePath()+File.separatorChar+"wstsl");
		File wsdl = new File(file.getAbsolutePath()+File.separatorChar+"wsdl");
		File target = new File(file.getAbsolutePath()+File.separatorChar+"wstsl"+File.separatorChar+"target");
		
		wsdd.mkdir();
		wstsl.mkdir();
		wsdl.mkdir();
		target.mkdir();
		
	}  

}
