package targetgenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.axis.client.AdminClient;
import org.xml.sax.SAXException;

import parser.WSDLComplexTypeParser;
import parser.WSDLParameterParser;
import parser.WSDLServiceParser;
import util.Config;
 
import com.sun.tools.javac.Main;

import dao.TGDAO;

public class Target {

	private static Logger log = Logger.getLogger(Target.class.toString());

	private String targetname;
	private LinkedList<ServiceInfo> services;
	private LinkedList<ComplexType> complexTypes;
	private LinkedList<TargetMethod> methods;

	//variabili di servizio
	private LinkedList<String> acts;
	private SAXParserFactory factory;

	//mapping degli attributi e complextype per i parser
	private static Hashtable<String, String> javaType = new Hashtable<String, String>();
	private static Hashtable<String, String> javaCast = new Hashtable<String, String>();


	public Target(String t){
		targetname = t;
	}

	public String createAndDeploy()throws SQLException, IOException, ParserConfigurationException, SAXException, CompositionException, InterruptedException{
		log.info("******************** Target generation process has started ********************");
		log.info("Targetname: "+targetname);
		log.info("Initializing database and data structures");

		initData();

		log.info("Creating and deploying ComplexTypes java files");

		Iterator<ComplexType> it = complexTypes.iterator();

		while(it.hasNext()){
			ComplexType ct = it.next();
			File fcomplextype = this.createJavaComplexTypeFile(ct);
			deployJavaFile(fcomplextype);
		}

		log.info("Creating target java file");

		File ftargetclass = this.createJavaTargetFile();

		log.info("Compiling and deploying target java file");

		deployJavaFile(ftargetclass);

		log.info("Creating target wsdd file");

		File fwsdd = createWSDDFile();

		log.info("Deploying target wsdd file");

		this.deployWSDDFile(fwsdd);

		log.info("Process completed, the target web service is ready. Clients can start invoking operations");

		return getAddress();
	}

	public String getAddress() throws UnknownHostException {
		InetAddress inetAdd = InetAddress.getByName("localhost");
		String address = "http://"+inetAdd.getHostAddress()+":"+Config.getInstance().getProperty(Config.AXIS_PORT)+"/"+Config.getInstance().getProperty(Config.AXIS_CONTEXT_ROOT)+"/services/urn:"+targetname;
		return address;
	}

	private void initData() throws SQLException, IOException, ParserConfigurationException, SAXException, CompositionException{
		//Creazione della tabella per la composizione dallo script sql precedentemente generato
		try{
			String fileSQL = Config.getInstance().getProperty(Config.PREFIX)+File.separator+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+"/"+getTargetname()+"/"+Config.getInstance().getProperty(Config.DB_COMPOSITION_FILE);
			TGDAO.buildCompositionDB(fileSQL);
			log.info("OG Table stored into the database using script " + Config.getInstance().getProperty(Config.DB_COMPOSITION_FILE));
		}
		catch(IOException ex){
			log.severe("File " + Config.getInstance().getProperty(Config.DB_COMPOSITION_FILE) + " does not exist in "+targetname+" directory");
			throw new CompositionException(2, "File " + Config.getInstance().getProperty(Config.DB_COMPOSITION_FILE) + " does not exist in "+targetname+" directory");
		}
		//lista dei nomi dei metodi del target, questa lista serve solo in fase di parzializzazione, per ottenere la vera lista dei metodi
		acts = TGDAO.getActionNames(getTargetname());
		//liste dei servizi della community e dei dettagli sui metodi del target
		services = new LinkedList<ServiceInfo>();
		methods = new LinkedList<TargetMethod>();
		complexTypes = new LinkedList<ComplexType>();
		//inizializzazione delle hashtable per la mappatura degli attributi
		fillJavaTypes();
		fillJavaCasts();

		//Sono costretto a fare una cosa un po' strana, leggo i nomi dei file WSTSL da ognuno di essi prendo il nome e vado a cercare il file nella wsdl, non leggo direttamente nella cartella wsdl perchè l'ordine potrebbe essere diverso
		File dir = null;
		dir = new File(Config.getInstance().getProperty(Config.PREFIX)+File.separator+getDircomposizioni()+File.separator+getTargetname()+File.separator+"wstsl");
		File[] wstslFiles = dir.listFiles();
		factory = SAXParserFactory.newInstance();
		for(int i = 0; i<wstslFiles.length; i++){
			File fwstsl = wstslFiles[i];
			String filename = fwstsl.getName();
			//System.out.println(filename);
			String parts[] = filename.split("\\.");//bisogna mettere \\ se no non funziona
			String solonome = "";
			String extension = "";
			if(parts.length == 2){
				solonome = parts[0];
				extension = parts[1];
				//System.out.println(solonome+" "+extension);
			}
			if(!fwstsl.isDirectory()&& extension!=null && extension.equals("wstsl")&& solonome!=null && !solonome.equals("")){
				//apro il file wsdl nella cartella wsdl con lo stesso nome del file wstsl
				String nuovonome = Config.getInstance().getProperty(Config.PREFIX)+File.separator+getDircomposizioni()+File.separator+getTargetname()+File.separator+"wsdl"+File.separator+solonome+".wsdl";
				//System.out.println(nuovonome);
				File fwsdl = new File(nuovonome);
				//parse del un file: crea la serviceinfo e i targetMethod di quel servizio
				parseServiceFile(fwsdl);
			}
		}

		/*
		 * 
		 * Questo è corretto se i file sono ordinati per nome altrimenti la leggo i nomi dalla dir WSTSL
		 * 
        //lista dei file wsdl dei servizi della comunity
        dir = new File(getDircomposizioni()+"/"+getTargetname()+"/wsdl");
        File[] wsdlFiles = dir.listFiles();
        if(wsdlFiles.length == 0)
            throw new CompositionException(2, "Wsdl files are missin in "+targetname+"\\wsdl directory");
        //stampaFiles(wsdlFiles); Per il debugging
        Arrays.sort(wsdlFiles);

        //creazione della factory per la creazione dei parser
        factory = SAXParserFactory.newInstance();
        for(int i = 0; i<wsdlFiles.length; i++){
            File f = wsdlFiles[i];
            String filename = f.getName();
            String extension = (filename.substring(filename.length()-4));
            if(!f.isDirectory()&& extension!=null && extension.equals("wsdl")){
                //parse del un file: crea la serviceinfo e i targetMethod di quel servizio
                parseServiceFile(f);
            }
        }
		 */
		//controllo di correttezza
		checkParse();
		//metodo di test per stampare le strutture, da commentare nella versione finale,da usare per debugging
		//stampaData();

	}

	private File createJavaComplexTypeFile(ComplexType ct) throws FileNotFoundException{
		String javaFile = "package "+targetname+";\n\nimport java.io.*;\n\n";
		javaFile+="public class "+ct.getName()+" implements Serializable{\n\n";
		javaFile += createVariablesCT(ct);
		javaFile += createConstructorCT(ct);
		javaFile += createMethodsCT(ct);
		javaFile+="}";
		File f = new File(ct.getName()+".java");
		PrintWriter p = new PrintWriter(f);
		p.print(javaFile);
		p.close();
		//System.out.println(javaFile);
		log.info("File "+f.getName()+" created successfully in composition directory");
		return f;
	}

	private File createJavaTargetFile() throws FileNotFoundException{
		String javaFile = "package "+targetname+";\n\nimport orchestrator.*;\nimport javax.xml.rpc.ServiceException;\nimport java.util.*;\n\n";
		javaFile+="public class "+targetname+" {\n";
		javaFile+="\n\tprivate Orchestrator orchestrator;\n\tprivate String tablename;\n";
		javaFile+=createConstructor();
		javaFile+=createMethods();
		javaFile+=createGetStatus();
		javaFile+="\n}";
		File f = new File(targetname+".java");
		PrintWriter p = new PrintWriter(f);
		p.print(javaFile);
		p.close();
		log.info("File "+f.getName()+" created successfully in composition directory");
		//System.out.println(javaFile);   
		return f;
	}

	private void deployJavaFile(File f) throws IOException, InterruptedException, CompositionException{
		//cancello il file se percaso è rimasto li
		String percorso = Config.getInstance().getProperty(Config.TOMCAT_DIR)+File.separator+targetname+File.separator+f.getName();
		File daCancellare = new File(percorso);
		daCancellare.mkdirs();
		daCancellare.delete();
		//sposto il java da composizioni nella cartella di tomcat
		File inTomcat = new File(percorso);
		f.renameTo(inTomcat);
		//compilo il file nella cartella di tomcat
		//System.out.println(javac+" "+percorso);
		//System.out.println("cmd /c "+javac+" -cp "+cp+" "+percorso);
//		this.safeExec(Config.getInstance().getProperty(Config.JAVAC_BIN+" -cp "+Config.getInstance().getProperty(Config.CLASSPATH+" \""+percorso+"\"");
		
//		String[] args = {"-classpath" + " C:\\Programmi\\Java\\jdk1.6.0_01\\lib\\tools.jar;\"C:\\Programmi\\Apache Software Foundation\\Tomcat 6.0\\webapps\\axis\\WEB-INF\\classes\";\"C:\\Programmi\\Apache Software Foundation\\Tomcat 6.0\\webapps\\axis\\WEB-INF\\lib\\jaxrpc.jar\"" + " \""+percorso+"\""};
		String[] args = {"-classpath", Config.getInstance().getProperty(Config.CLASSPATH), percorso};
//		log.info("Compilo " + args[0] + " " + args[1]+ " " + args[2]);
		int result = Main.compile(args, new PrintWriter(System.out));
		//risposto il file java dalla cartella di tomcat in quella delle composizioni
		daCancellare = new File(Config.getInstance().getProperty(Config.PREFIX)+File.separator+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separator+targetname+File.separator+f.getName());
		daCancellare.delete();
		inTomcat.renameTo(new File(Config.getInstance().getProperty(Config.PREFIX)+File.separator+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separator+targetname+File.separator+f.getName()));
		
		if (result != 0)
			throw new CompositionException(0, "Java file not compiled; javac error code: " + result);
	}

	private File createWSDDFile() throws FileNotFoundException {
		String wddFile = "<deployment xmlns=\"http://xml.apache.org/axis/wsdd/\" xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">\n";
		wddFile += "\t<service name=\"urn:"+targetname+"\" provider=\"java:RPC\">\n";
		wddFile += "\t\t<parameter name=\"className\" value=\""+targetname+"."+targetname+"\"/>\n";
		wddFile += "\t\t<parameter name=\"allowedMethods\" value=\"";  
		Iterator<TargetMethod> it = methods.iterator();
		while(it.hasNext()){
			TargetMethod tm = it.next();
			wddFile+=tm.getName()+", ";//posso sempre mettere la virgola perchè c'e' getStatus alla fine
		}
		wddFile += "getStatus\"/>\n";
		wddFile += "\t\t<parameter name=\"scope\" value=\"Session\"/>\n";

		wddFile += createBeanMappings();
		wddFile += "\t</service>\n</deployment>\n";
		File wsddf = new File(Config.getInstance().getProperty(Config.PREFIX)+File.separator+Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI)+File.separator+targetname+File.separator+targetname+".wsdd");
		PrintWriter p = new PrintWriter(wsddf);
		p.print(wddFile);
		p.close();
		log.info("File "+wsddf.getName()+" created successfully in composition directory");
		return wsddf;
	}

	private void deployWSDDFile(File wsddf) throws IOException, InterruptedException, CompositionException {
/*		String percorso = wsddf.getPath();
		this.safeExec(Config.getInstance().getProperty(Config.JAVA_BIN+" -cp "+Config.getInstance().getProperty(Config.AXIS_CLASSPATH+" "+Config.getInstance().getProperty(Config.AXIS_ADMIN_CLIENT+" "+percorso);

		String[] args = {" -cp "+Config.getInstance().getProperty(Config.AXIS_CLASSPATH)+" "+Config.getInstance().getProperty(Config.AXIS_ADMIN_CLIENT)+" \""+percorso + "\""};
		Main.compile(args, new PrintWriter(System.out));
*/		
		String[] args = {wsddf.getPath()};
		AdminClient.main(args);
	}

	public String createBeanMappings(){
		String result = "";
		Iterator<ComplexType> it = complexTypes.iterator();
		while(it.hasNext()){
			ComplexType ct = it.next();
			result += "<beanMapping qname=\"myNS:"+ct.getName()+"\" xmlns:myNS=\"urn:"+targetname+"\" languageSpecificType=\"java:"+targetname+"."+ct.getName()+"\"/>\n";
		}
		return result;

	}

	public String createVariablesCT(ComplexType ct){
		String result = "";
		Iterator<TargetParam> it = ct.getParams().iterator();
		while(it.hasNext()){
			TargetParam t = it.next();
			result += "\tprivate "+t.type+" "+t.nome+";\n";
		}
		result += "\n";
		return result;
	}

	public String createConstructorCT(ComplexType ct){
		return "\tpublic "+ct.getName()+"(){}\n\n";
	}

	public String createMethodsCT(ComplexType ct){
		String result = "";
		Iterator<TargetParam> it = ct.getParams().iterator();
		while(it.hasNext()){
			TargetParam t = it.next();
			String getOis = "get";
			if(t.type.equalsIgnoreCase("boolean"))
				getOis = "is";
			//per creare il metodo getNome devo uppercasare solo l'iniziale
			String inizialeM = (t.nome.substring(0,1)).toUpperCase(); //iniziale maiuscola
			String nomeM = inizialeM+t.nome.substring(1); //inizialeM + il resto del nome
			//metodo get
			result += "\tpublic "+t.type+" "+getOis+nomeM+"(){\n";
			result += "\t\treturn "+t.nome+";\n\t}\n\n";
			//metodo set
			result += "\tpublic void set"+nomeM+"("+t.type+" "+"param"+"){\n";
			result += "\t\t"+t.nome+" = param;\n\t}\n\n";
		}
		return result;
	}

	private String createConstructor(){
		int num = services.size();
		String constructor = "\n\tpublic "+targetname+"() throws Exception{ ";
		constructor+="\n\t\ttablename = \""+targetname+"\";";
		constructor+="\n\t\tServiceInfo[] services = new ServiceInfo["+num+"];";
		for(int i=0;i<num;i++){
			constructor+="\n\t\tservices["+i+"] = new ServiceInfo(\""+services.get(i).getAddress()+"\", \""+services.get(i).getName()+"\");";
		}
		constructor+="\n\t\tLinkedList<Class> complexTypes = new LinkedList<Class>();";
		Iterator<ComplexType> it = complexTypes.iterator();
		while(it.hasNext()){
			ComplexType ct = it.next();
			constructor+= "\n\t\tcomplexTypes.add("+ct.getName()+".class);";
		}
		constructor+="\n\t\torchestrator = new Orchestrator(services, tablename, complexTypes);";
		constructor+="\n\t}\n";
		return constructor;
	}

	private String createMethods(){
		String m = "";
		int num = methods.size();
		TargetMethod met;
		LinkedList<TargetParam> tp;
		String p; // lista dei parametri e nome es String nome,String cognome
		for(int i = 0;i<num;i++){
			met = methods.get(i);
			m+="\n\tpublic "+met.getOutputtype()+" "+met.getName()+"(";
			tp=met.getParams();        
			p=getParameterTypeAndNameList(tp);
			m+=p;
			m+=")throws Exception{";
			p=getParameterNameList(tp);
			m+=" \n\t\tObject[] params = {"+p+"};";
			m+="\n\t\tObject risposta = orchestrator.invokeOperation(\""+met.getName()+"\", params);";
			if (!met.getOutputtype().equals("void")) 
				m+="\n\t\treturn ("+met.getOutputcast()+")risposta;";
			m+="\n\t}\n";
		}
		return m;
	}

	private String createGetStatus(){
		return "\n\tpublic int getStatus(){  return orchestrator.getTargetState(); } \n ";
	}

	private String getParameterTypeAndNameList(LinkedList<TargetParam> tp){
		String p="";
		for(int j=0;j<tp.size();j++){
			p+=tp.get(j).type+" "+tp.get(j).nome;
			if (j<tp.size()-1) p+=",";
		}
		return p;
	}

	private String getParameterNameList(LinkedList<TargetParam> tp){
		String p="";
		for(int j=0;j<tp.size();j++){
			p+=tp.get(j).nome;
			if (j<tp.size()-1) p+=",";
		}
		return p;
	}

	private void parseServiceFile(File f) throws ParserConfigurationException, SAXException, IOException {
		//primo parse del file per creare la serviceInfo(name,address)
		log.info("Parsing file: "+f.getName());
		SAXParser saxParser = factory.newSAXParser();
		WSDLServiceParser wp = new WSDLServiceParser();
		saxParser.parse(f, wp);
		//aggiunge la serviceInfo a quelle già create
		services.add(wp.getServizio());
		//individua ed estrae eventuali ComplexType dal WSDL. Il parser li aggiunge direttamente alla lista del target e aggiorna anche le hashtable dei tipi facendo sideeffect
		WSDLComplexTypeParser wctp = new WSDLComplexTypeParser(wp.getServizio().getName(), complexTypes, javaType, javaCast);
		saxParser.parse(f, wctp);
		//per ogni operazione in acts, parso il file per vedere se è presente e in quel caso aggiungo il targetmetod alla lista e rimuovo l'op da act
		Iterator<String> it = acts.iterator();
		while(it.hasNext()){
			String act = it.next();
			WSDLParameterParser wpp = new WSDLParameterParser(act, javaType, javaCast);
			saxParser.parse(f, wpp);
			if(wpp.isFound()){
				TargetMethod tm = wpp.getMethod();
				if(tm.getOutputtype()==null || tm.getOutputtype().equals(""))
					tm.setOutputtype("void");
				methods.add(tm);
				it.remove();
			}
		}
	}

	private void fillJavaTypes() {
		//dello standard XML schema data type

		javaType.put("any[]", "Object[]");
		javaType.put("anyType", "Object");
		javaType.put("anySimpleType", "String");
		javaType.put("anyURI", "String");
		javaType.put("Array", "Object[]");
		javaType.put("ArrayOf_xsd_anyType", "Object[]");
		javaType.put("base64Binary", "byte[]");
		javaType.put("base64", "byte[]");
		javaType.put("boolean", "boolean");
		javaType.put("byte", "byte");
		javaType.put("date", "java.util.Calendar");
		javaType.put("dateTime", "java.util.Calendar");
		javaType.put("decimal", "java.math.BigDecimal");
		javaType.put("date", "java.util.Calendar");
		javaType.put("double", "double");
		javaType.put("duration", "org.apache.xmlbeans.GDuration");
		javaType.put("Element", "org.w3c.dom.Element");
		javaType.put("ENTITIES", "String");
		javaType.put("ENTITY", "String");
		javaType.put("float", "float");
		javaType.put("qDay", "java.util.Calendar");
		javaType.put("qMonth", "java.util.Calendar");
		javaType.put("qMonthDay", "java.util.Calendar");
		javaType.put("qYear", "java.util.Calendar");
		javaType.put("qYearMonth", "java.util.Calendar");
		javaType.put("hexBinary", "byte[]");
		javaType.put("ID", "String");
		javaType.put("IDREF", "String");
		javaType.put("IDREFS", "String");
		javaType.put("int", "int");
		javaType.put("integer", "Integer");
		javaType.put("language", "String");
		javaType.put("long", "long");
		javaType.put("Name", "String");
		javaType.put("NCName", "String");
		javaType.put("negativeInteger", "java.math.BigInteger");
		javaType.put("NMTOKEN", "String");
		javaType.put("NMTOKENS", "String");
		javaType.put("nonNegativeInteger", "java.math.BigInteger");
		javaType.put("nonPositiveInteger", "java.math.BigInteger");
		javaType.put("normalizedString", "String");
		javaType.put("NOTATION", "Object");
		javaType.put("positiveInteger", "Integer");
		javaType.put("QName", "javax.xml.namespace.QName");
		javaType.put("short", "short");
		javaType.put("string", "String");
		javaType.put("time", "java.util.Calendar");
		javaType.put("token", "String");
		javaType.put("unsignedByte", "short");
		javaType.put("unsignedInt", "long");
		javaType.put("unsignedLong", "java.math.BigInteger");
		javaType.put("unsignedShort", "int");
		javaType.put("Vector", "java.util.Vector");
		//aggiunti da me
		javaType.put("", "void");
		javaType.put("void", "void");
		javaType.put("Object", "Object");
	}


	private void fillJavaCasts() {
		javaCast.put("int", "Integer");
		javaCast.put("long", "Long");
		javaCast.put("short", "Short");
		javaCast.put("float", "Float");
		javaCast.put("double", "Double");
		javaCast.put("boolean", "Boolean");
		javaCast.put("byte", "Byte");
	}

	private void checkParse() throws CompositionException {
		if(acts.size()!=0){
			for(int i = 0; i< acts.size(); i++)
				log.info(acts.get(i)+" ");
			throw new CompositionException(3,"Community services do not have all target needed methods because methods could have different names in different services or some WSDL files are missing.");
		}
		Iterator<ComplexType> ite = complexTypes.iterator();
		while(ite.hasNext()){
			ComplexType ct = ite.next();
			if(ct.getName() == null)
				throw new CompositionException(4,"WSDL are not correct and complete.\nComplextType of the service's schema found with no name.");
			LinkedList<TargetParam> l = ct.getParams();
			Iterator<TargetParam> iter = l.iterator();
			while(iter.hasNext()){
				TargetParam t = (TargetParam)iter.next();
				if(t.nome == null || t.nome.equals("") || t.type == null || t.type.equals(""))
					throw new CompositionException(4,"WSDL are not correct and complete.\nComplextType of the service's schema found with no wrong attribute definition, impossible to recognize attribute name or type.");
			}
		}

		Iterator<ServiceInfo> it = services.iterator();
		while(it.hasNext()){
			ServiceInfo si = it.next();
			if(si.getName() == null || si.getAddress() == null || si.getName().equals("") || si.getAddress().equals(""))
				throw new CompositionException(4,"WSDL are not correct and complete.\nImpossible to retrieve address and name of all community services.");
		}
	}   

	public String getTargetname() {
		return targetname;
	}

	public void setTargetname(String targetname) {
		this.targetname = targetname;
	}

	public LinkedList<ServiceInfo> getServices() {
		return services;
	}

	public LinkedList<TargetMethod> getMethods() {
		return methods;
	}

/*	//se invochiamo la exec senza gestire l'error stream, se c'e' un errore si riempie il buffer , il processo va in blocco fino a che il buffer non si svuota e quindi la waitfor non termina più
	private void safeExec(String command) throws IOException, InterruptedException, CompositionException {
		Process p = Runtime.getRuntime().exec(command);
		InputStream stderr = p.getErrorStream();
		InputStreamReader isr = new InputStreamReader(stderr);
		BufferedReader br = new BufferedReader(isr);
		String line = null;
		boolean error = false;
		while ( (line = br.readLine()) != null){
			log.info(line);
			// gli warning di log4j non costituiscono poi un grosso pericolo:
			if (!line.contains("WARN"))
				error = true;
		}   
		p.waitFor();
		if(error){
			log.severe("Target generation aborted because an error occurred during compilation or publishing\nError occurred executing command:\n\n"+command+"\n\n");
			throw new CompositionException(5,"\n\nTarget generation aborted because an error occurred during compilation or publishing\nError occurred executing command:\n\n"+command+"\n\n");
		}
	}
*/
/*	private void stampaData() {
		for(int i = 0; i<services.size();i++){
			ServiceInfo si = services.get(i);
			log.info(si.getName()+" "+si.getAddress());
		}
		log.info("");
		for(int i = 0; i<methods.size();i++){
			TargetMethod t = methods.get(i);
			log.info(t.getName()+" "+t.getOutputtype());
			LinkedList<TargetParam> params = t.getParams();
			for(int j = 0; j< params.size();j++){
				TargetParam tp = params.get(j);
				log.info(tp.nome+" "+tp.type);
			}
			log.info("");    
		}
		for(int i = 0; i<complexTypes.size();i++){
			ComplexType c = complexTypes.get(i);
			log.info("Complextype: "+c.getName());
			LinkedList<TargetParam> params = c.getParams();
			for(int j = 0; j< params.size();j++){
				TargetParam tp = params.get(j);
				log.info(tp.nome+" "+tp.type);
			}
			log.info("");    
		}
	}
*/
/*	private void stampaFiles(File[] wsdlFiles) {
		for(int i = 0; i<wsdlFiles.length; i++){
			File f = wsdlFiles[i];
			log.info(f.getName()+" "+f.getPath());
		}
	}
*/
	public static String getDircomposizioni() {
		return Config.getInstance().getProperty(Config.DIR_COMPOSIZIONI);
	}
}
