package parser;

// SAX IMPORTS
import org.xml.sax.*;
import org.xml.sax.helpers.*;

// JAVA IMPORTS
import javax.xml.parsers.*;

import java.io.*;
import java.util.*; 
import targetgenerator.ServiceInfo;
import targetgenerator.*;

public class WSDLParameterParser extends DefaultHandler {
    
    
    private TargetMethod method;
    private String act;
    private boolean found;
    
    private static Hashtable<String, String> javaType;
    private static Hashtable<String, String> javaCast;
    
    private int stato = INITIAL_STATE;
    final static int INITIAL_STATE = 0;
    final static int RESPONSE = 1;
    final static int REQUEST = 2;
    
    /** Creates a new instance of NDTypeParser */
    public WSDLParameterParser(String a, Hashtable types, Hashtable casts) {
        act = a;
        method = new TargetMethod();
        method.setName(act);
        found = false;
        javaType = types;
        javaCast = casts;
    }
    /*
    public void startDocument() {} 
    public void endDocument() {} 
    */	
 	
    public void characters(char[] ch, int start, int len) {}
 	
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) { 
            //wsdl:message opResponse
            if(qName.equalsIgnoreCase("wsdl:message")){
                if(atts.getValue("name").equalsIgnoreCase(act+"Response")){
                    stato = RESPONSE;
                }
            }
            if(stato == RESPONSE){
                if(qName.equalsIgnoreCase("wsdl:part")){
                    String output = atts.getValue("type");//prendo il tipo dall'xml
                    String param = getParam(output);//lo traduco in tipo java
                    method.setOutputtype(param);
                    method.setOutputcast(getCastFromParam(param));//per il cast effettuo un altra traduzione
                }       
            }
            //wsdl:message opRequest
            if(qName.equalsIgnoreCase("wsdl:message")){
                if(atts.getValue("name").equalsIgnoreCase(act+"Request")){
                    stato = REQUEST;
                }
            }
            if(stato == REQUEST){
                if(qName.equalsIgnoreCase("wsdl:part")){
                    String type = atts.getValue("type");
                    String name = atts.getValue("name");
                    TargetParam tp = new TargetParam();
                    tp.nome = name;
                    String param = getParam(type);
                    tp.type = param;
                    method.getParams().add(tp);
                }       
            }
            if(qName.equalsIgnoreCase("wsdl:operation")){
                if(atts.getValue("name").equalsIgnoreCase(act)){
                    found = true;
                }
            }        
    }
        
    public void endElement(String uri, String localName, String qName) {
        if(qName.equalsIgnoreCase("wsdl:message")){
            stato = INITIAL_STATE;
        }
    }

    public TargetMethod getMethod() {
        return method;
    }

    private String getParam(String p) {
        //il type in genere è xsd:string, quindi devo considerare la seconda parte dopo i 2 punti, in tutti gli altri casi metto Object o void
        String result = null;
        if(p == null){//non c'e' parametro, puo succedere solo per il tipo restituito e quindi metto void
            result = "void";
        }
        else{
            String[] parts = p.split(":");
            if(parts.length > 2){//se sono piu di due parti non so come trattarlo e quindi lascio Object
                result = "Object";
            }
            else if(parts.length == 2){
                result = javaType.get(parts[1]);
            }
            else if(parts.length == 1){
                result = javaType.get(parts[0]);
            }
            else result = "void";
            if(result == null){//non ho trovato la traduzione nell'hashTable quindi metto Object
                if(p.contains("[]"))
                    result = "Object[]";
                else result = "Object";
            }
        }
        return result;
    }
    
    public String getCastFromParam(String pa){
        String result = javaCast.get(pa);//vedo se il parametro deve essere ulteriormente trasformato per il cast se no lascio quello che è
        if(result == null)
            result = pa;
        return result;
    }

    public boolean isFound() {
        return found;
    }

    
}