package parser;

// SAX IMPORTS
import org.xml.sax.*;
import org.xml.sax.helpers.*;

// JAVA IMPORTS
import javax.xml.parsers.*;

import java.io.*;
import java.util.*; 
import targetgenerator.ServiceInfo;
import targetgenerator.*;

public class WSDLComplexTypeParser extends DefaultHandler {
    
    
    private LinkedList<ComplexType> types;
    private ComplexType ct;
    
    String service;
    private static Hashtable<String, String> javaType;
    private static Hashtable<String, String> javaCast;
    
    private int stato = INITIAL_STATE;
    final static int INITIAL_STATE = 0;
    final static int INSCHEMA = 1;//quando sto nello stato INSCHEMA leggo i complextype
    final static int INCOMPLEX = 2;
    final static int INSEQUENCE = 3;//quando sto nello stato INSEQUENCE leggo gli attributi
    final static int OUTSEQUENCE = 4;
    final static int FINAL_STATE = 5;
    
    /** Creates a new instance of NDTypeParser */
    public WSDLComplexTypeParser(String servname,LinkedList<ComplexType> ctypes, Hashtable jtypes, Hashtable casts) {
        service = servname;
        //queste sono liste del target, il parser fa direttamente sideeffect su di esse
        types = ctypes;
        javaType = jtypes;
        javaCast = casts; 
    }
    /*
    public void startDocument() {} 
    public void endDocument() {} 
    */	
 	
    public void characters(char[] ch, int start, int len) {}
 	
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) { 
            if(qName.equalsIgnoreCase("schema")){
                if(atts.getValue("targetNamespace").equalsIgnoreCase(service)){
                    stato = INSCHEMA;
                }
            }
            if(stato == INSCHEMA){
                if(qName.equalsIgnoreCase("complexType")){
                    ct = new ComplexType();
                    ct.setName(atts.getValue("name"));
                    ct.setServicename(service);
                    //ogni complextype è un possibile attributo degli altri metodi o degli altri compextype, potrebbe anche avere un attributo dello stessa tipologia di complextype
                    //se il complextype è già stato trovato in un altra WSDL, la chiave nell'hashtable viene sovrascritta, e non genera quindi errori.
                    javaType.put(ct.getName(),ct.getName()); 
                    stato = INCOMPLEX;
                }       
            }
            if(stato == INCOMPLEX){
                if(qName.equalsIgnoreCase("sequence")){
                    stato = INSEQUENCE;
                }       
            }
            if(stato == INSEQUENCE){
                if(qName.equalsIgnoreCase("element")){
                    TargetParam t = new TargetParam();
                    t.nome = atts.getValue("name");
                    t.type = getParam(atts.getValue("type"));
                    ct.getParams().add(t);
                }       
            }        
    }
        
    public void endElement(String uri, String localName, String qName) {
        if(stato == INSEQUENCE){
            if(qName.equalsIgnoreCase("sequence")){
                 stato = OUTSEQUENCE;
            }            
        }
        if(stato == OUTSEQUENCE){
            if(qName.equalsIgnoreCase("complexType")){
                if(!types.contains(ct)){
                    types.add(ct);
                    //la put nell'hashtable la faccio appena leggo il nome del complextype quindi nella startElement()
                }
                stato = INSCHEMA;
            }
        }
        if(stato == INSCHEMA){
            if(qName.equalsIgnoreCase("schema")){
                 stato = FINAL_STATE;
            }            
        }

    }

    private String getParam(String p) {
        //il type in genere è xsd:string, quindi devo considerare la seconda parte dopo i 2 punti, in tutti gli altri casi metto Object o void
        String result = null;
        if(p == null){//non c'e' parametro, puo succedere solo per il tipo restituito e quindi metto void
            result = "void";
        }
        else{
            String[] parts = p.split(":");
            if(parts.length > 2){//se sono piu di due parti non so come trattarlo e quindi lascio Object
                result = "Object";
            }
            else if(parts.length == 2){
                result = javaType.get(parts[1]);
            }
            else if(parts.length == 1){
                result = javaType.get(parts[0]);
            }
            else result = "void";
            if(result == null){//non ho trovato la traduzione nell'hashTable quindi metto Object o Object[] è una forzatura mia
                if(p.contains("[]"))
                    result = "Object[]";
                else result = "Object";
            }
        }
        return result;
    }
    
    public String getCastFromParam(String pa){
        String result = javaCast.get(pa);//vedo se il parametro deve essere ulteriormente trasformato per il cast se no lascio quello che è
        if(result == null)
            result = pa;
        return result;
    }
    
}