
package org.dis.uniroma1.swsce.fsm.test;

import org.dis.uniroma1.swsce.fsm.*;
import java.util.*;

public class TestFSM {
	
	public static void main(String[] args) throws Exception {
		
		Fsm g = new Fsm();
		
		State s0 = new State("S0",StateDescription.INITIAL_FINAL);
		State s1 = new State("S1",StateDescription.TRANSIENT);
		State s2 = new State("S2",StateDescription.FINAL);
		
		
		Transition a0 = new Transition("a0",s0,s1);
		Transition a1 = new Transition("a1",s0,s1);
		Transition b = new Transition("b",s0,s2);
		Transition c = new Transition("c",s2,s1);
		Transition d = new Transition("d",s1,s2);
		Transition e = new Transition("e",s1,s1);
		
		
		//Transition t = new Transition(null,null,null);
		
		g.addTransition(a0);
                a0 = new Transition("a0",s0,s0);
                g.addTransition(a0);
		g.addTransition(a1);
		g.addTransition(b);
		g.addTransition(c);
		g.addTransition(d);
		g.addTransition(e);
		
                /*
                int comp = "S0".compareToIgnoreCase("S1");
                System.out.println(comp);
                if(comp<0)
                    System.out.println("S0 piu piccolo");
                else
                    System.out.println("S0 piu grande");
		*/
                
                Set<Transition> nonTrans = g.nonTransition(s0);
                
                for(Transition t : nonTrans)
                    System.out.println(t);
                
		System.out.println("Grafo:\n"+g+"\r\n");
                boolean[][] am = g.adiacenceMatrix();
                
                for(int i=0; i<am.length; i++) {
                    for(int j=0; j<am[0].length; j++) {
                        System.out.println("da stato: "+i+" a stato: "+j+" "+am[i][j]);
                    }
                }
                    
		
		//System.out.println("Ha un singolo stato iniziale: "+g.checkSingleInitialState());
		System.out.println("Ha stati isolati: "+g.checkIsolateStates()); 
		
		System.out.println("Aggiungo uno stato isolato, S3 senza transizioni.\r\n ");
		State s3 = new State("S3",StateDescription.TRANSIENT);
                g.addState(s3);
		System.out.println("Grafo:\n"+g+"\r\n ripeto i test....\r\n");
		//System.out.println("Ha un singolo stato iniziale: "+g.checkSingleInitialState());
		System.out.println("Ha stati isolati: "+g.checkIsolateStates()); 
		
		
		System.out.println("Aggiungo la transizione self allo stato isolato S3"+"\r\n");
		Transition self = new Transition("Self",s3,s3);
		g.addTransition(self);
		System.out.println("Grafo:\r\n"+g+"\r\n ripeto i test....\r\n");
		//System.out.println("Ha un singolo stato iniziale: "+g.checkSingleInitialState());
		System.out.println("Ha stati isolati: "+g.checkIsolateStates());
		
		//System.out.println(t);
	}
}