package org.dis.uniroma1.swsce.fsm.parser;

//LOCAL IMPORTS
import org.dis.uniroma1.swsce.fsm.*;

// SAX IMPORTS
import org.xml.sax.*;
import org.xml.sax.helpers.*;

// JAVA IMPORTS
import javax.xml.parsers.*;

import java.io.*;
import java.util.*; 

/**
 * This class pre parse a WS-TSL document to get the states of the TS.
 * @see for more detail on how to describe the behavior of Web Service using a Fsm see Automatic 
 * Web Service Coposition M.Mecella and G. De Giacomo 2006 - Tutorial @ ICWS 2006 (Chicago, USA)
 * 
 * @see articolo tesi for more detail on WS-TSL.
 * 
 * @author Valerio Colaianni
 */
public class preParseWSTSL extends DefaultHandler {	
	
        private ArrayList<State> states;
        private State s;
	
	/**
         * Construct the Parser
         */
	public preParseWSTSL() {
            
            states = new ArrayList<State>();
            s = null;
	}
	
	/**
         * @return fsm: The Fsm of the parsed WS-CDL
         */
	public ArrayList<State> getStates() {
		return states;
	}
	
	public void startDocument() { 
	  	
	  	
 	} 
	
	
	public void endDocument() { 
	 	
	 	
	} 
 	
 	
 	public void characters(char[] ch, int start, int len) {
           
 	}
 	
 	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) { 
		
            if (qName.equalsIgnoreCase("state")) {
                //System.out.println("ho beccato lo stato: " + atts.getValue("name"));
                s = new State();
                
                s.setName(atts.getValue("name"));
                
                String d = atts.getValue("tipology");
                
                //System.out.println(d);
                
                if(d.equals("initial-final"))
                    s.setDescription(StateDescription.INITIAL_FINAL);
                if(d.equals("final"))
                        s.setDescription(StateDescription.FINAL);
                if(d.equals("transient"))
                        s.setDescription(StateDescription.TRANSIENT);
                    
                
                states.add(s);


            }
	   
       }
        
 	public void endElement(String uri, String localName, String qName) {
 		
 	}
}