package org.dis.uniroma1.swsce.fsm.parser;

//LOCAL IMPORTS
import org.dis.uniroma1.swsce.fsm.*;

// SAX IMPORTS
import org.xml.sax.*;
import org.xml.sax.helpers.*;

// JAVA IMPORTS
import javax.xml.parsers.*;

import java.io.*;
import java.util.*; 

/**
 * This class builds a FSM from a WS-TSL description of it.
 * @see for more detail on how to describe the behavior of Web Service using a Fsm see Automatic 
 * Web Service Coposition M.Mecella and G. De Giacomo 2006 - Tutorial @ ICWS 2006 (Chicago, USA)
 * 
 * @see articolo tesi for more detail on WS-TSL.
 * 
 * @author Valerio Colaianni
 */
public class WSTSLParser extends DefaultHandler {	
	
        /**
         * The parsed service behaviour as Fsm object
         */
	private Fsm fsm;
	
        // Other variables
        private ArrayList<State> states;
	private Transition transition;
	private State s;
	
	/**
         * Construct the Parser
         */
	public WSTSLParser(File preParse)  {
                //System.out.println("inizio costruttore WSTSLParser");
                SAXParserFactory parserFact = SAXParserFactory.newInstance();
                SAXParser parser = null;
                
                try {
                    parser = parserFact.newSAXParser();  
                } 
                catch (SAXException ex) {
                    ex.printStackTrace();
                } 
                catch (ParserConfigurationException ex) {
                    ex.printStackTrace();
                }
               //System.out.println("sto per chiamare costruttore preparse...");
                preParseWSTSL wp = new preParseWSTSL();
                //System.out.println("ho chiamato il costruttore preparse!");
                
                try {
                    //System.out.println("sto per preprocessare...");
                    parser.parse(preParse,wp);
                    //System.out.println("ho preprocessato!");
                } 
                catch (SAXException ex) {
                    ex.printStackTrace();
                } 
                catch (IOException ex) {
                    ex.printStackTrace();
                }
               //System.out.println("sto per prendere gli stati dal preprocessamento");
                states = wp.getStates();
                //System.out.println("stati dal preprocessamento: "+states);
                
		fsm = new Fsm();
                //System.out.println("creata la fsm vuota");
		s = null;
		transition = null;
                //System.out.println("FINE COSTRUTTORE WSTSLP");
	}
	
	/**
         * @return fsm: The Fsm of the parsed WS-CDL
         */
	public Fsm getFsm() {
		return fsm;
	}
	
	public void startDocument() { 
	  	
	  	
 	} 
	
	
	public void endDocument() { 
	 	
	 	
	} 
 	
 	
 	public void characters(char[] ch, int start, int len) {
 	}
 	
 	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) { 
	
            if(qName.equalsIgnoreCase("TS")) {
                String nome = atts.getValue("service");
                //System.out.println(nome);
                if(nome==null) {
                    //System.out.println("nome era null sono nell'IF leggo SERVICE");
                    
                    nome = atts.getValue("SERVICE");
                }
                fsm.setServiceName(nome);
                //System.out.println("ho inserito in serviceName: "+nome);
            }
            if (qName.equalsIgnoreCase("state")) {

                s = new State();
                s.setName(atts.getValue("name"));
                String d = atts.getValue("tipology");
                
                if(d.equals("initial-final"))
                    s.setDescription(StateDescription.INITIAL_FINAL);
                if(d.equals("final"))
                        s.setDescription(StateDescription.FINAL);
                if(d.equals("transient"))
                        s.setDescription(StateDescription.TRANSIENT);
                
                //System.out.println("sto processando lo stato: "+s);
                
            }
	    
	    if (qName.equalsIgnoreCase("transition")) {
	    	
	    	transition = new Transition();
                transition.setSource(s);
            
                transition.setAction(atts.getValue("action"));
	    	//System.out.println("azione: "+transition.getAction());
                //transition.setTarget(states.get(0));
            }    
                
            if (qName.equalsIgnoreCase("target")) {
                
                State targetState = null;
                Iterator<State> i = states.iterator();
                String stateName = atts.getValue("state");
                //System.out.println("targetName: " + stateName);
                while(i.hasNext()) {
                    State candidate = i.next();
                    if(candidate.getName().equals(stateName))
                        targetState = candidate;
                }
                //System.out.println("target: " + targetState);
                
                transition.setTarget(targetState);
                String condition = atts.getValue("condition");
                if(condition!=null)
                    transition.setCondition(condition);
                
                try {
                    //System.out.println("sto inserendo la trans: " + transition);
                    fsm.addTransition(transition);
                    //System.out.println("la fsm e': " + fsm);
                } 
                catch (NotFSMException ex) {
                    ex.printStackTrace();
                }
                
            }
            
       }
        
 	public void endElement(String uri, String localName, String qName) {
 		
                if(qName.equalsIgnoreCase("target")) {
                  
                    State source = transition.getSource();
                    String action = transition.getAction();
                    transition = new Transition();
                    transition.setSource(source);
                    transition.setAction(action);
                }
                if(qName.equalsIgnoreCase("TS")) {
                    //System.out.println("finito di parsare: "+this.fsm.getServiceName());
                }
 		
 	}
        
        public static void main(String[] args) throws Exception{
		
	 	//Si deve istanziare un oggetto della classe SAXParserFactory
		SAXParserFactory parserFact = SAXParserFactory.newInstance(); 
		
		//Quindi da questultimo si ottiene unistanza di parser SAX 
		SAXParser parser = parserFact.newSAXParser();
		
                String[] asf = {"test0.wstsl",
                                "test1.wstsl",
                                "test2.wstsl",
                                "test3.wstsl",
                                "test4.wstsl",
                                "test5.wstsl",
                                };
                
                File f = new File("C:/Composizioni/test6/wstsl/HKService.wstsl");
		WSTSLParser wp = new WSTSLParser(f);
		parser.parse(f,wp);
                PrintWriter pw = new PrintWriter(new FileOutputStream("C:/Composizioni/test6/wstsl/FSM.fsm"),true);
                pw.println(wp.getFsm().toString());
		System.out.println(wp.getFsm().getServiceName());
                Fsm fsm = wp.getFsm();
                for(State s : fsm.getStates())
                    System.out.println(s + " id:"+s.getStateID());
        }
}