package org.dis.uniroma1.swsce.fsm.parser;

//LOCAL IMPORTS
import org.dis.uniroma1.swsce.fsm.*;

// SAX IMPORTS
import org.xml.sax.*;
import org.xml.sax.helpers.*;

// JAVA IMPORTS
import javax.xml.parsers.*;

import java.io.*;
import java.util.*; 

/**
 * This class builds a FSM from a WS-CDL description of it.
 * @see for more detail on how to describe the behavior of Web Service using a Fsm see Automatic 
 * Web Service Coposition M.Mecella and G. De Giacomo 2006 - Tutorial @ ICWS 2006 (Chicago, USA) 
 * @author Valerio Colaianni
 */
public class WSCDLParser extends DefaultHandler {	
	
        /**
         * The parsed service behaviour as Fsm object
         */
	private Fsm fsm;
	
        // Other variables
        private ArrayList<State> states;
	private int index;
	private Transition transition;
	private State s;
	
	/**
         * Construct the Parser
         */
	public WSCDLParser()
	{
		fsm = new Fsm();
		states = new ArrayList<State>();
		index = -1;
		s = null;
		transition = null;
	}
	
	/**
         * @return fsm: The Fsm of the parsed WS-CDL
         */
	public Fsm getFsm() {
		return fsm;
	}
	
	public void startDocument() { 
	  	
	  	
 	} 
	
	
	public void endDocument() { 
	 	
	 	
	} 
 	
 	
 	public void characters(char[] ch, int start, int len) { 
  		
            String d = new String(ch,start,len);
            if(d.equals("initial-final") || d.equals("final") || d.equals("transient")) {

            s = states.get(index);

            if(d.equals("initial-final"))
                    s.setDescription(StateDescription.INITIAL_FINAL);
            if(d.equals("final"))
                    s.setDescription(StateDescription.FINAL);
            if(d.equals("transient"))
                    s.setDescription(StateDescription.TRANSIENT);

            //System.out.println("ho aggiunto la descrizione allo stato: "+s);

            } 
 	}
 	
 	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) { 
		
            if (qName.equals("choreography")) {

                s = new State();
                s.setName(atts.getValue("name"));
                //System.out.println("sto processando lo stato: "+s);
                states.add(s);
                index++;

            }
	    
	    if (qName.equals("workunit")) {
	    	
	    	s = new State();
	    	s.setName(atts.getValue(0));
	    	transition = new Transition(states.get(0),s);
	    	//System.out.println("ho creato la transizione: "+transition);
	    	states.add(s);
	    	index++;
	    	
	    	
	    }
            if (qName.equals("interaction")) {
                
                transition.setAction(atts.getValue("operation"));
                //System.out.println(transition+" is being added..");
                
                try {
                    fsm.addTransition(transition);
                   
                } 
                catch (NotFSMException ex) {
                    ex.printStackTrace();
                }
            }
       }
 	public void endElement(String uri, String localName, String qName) {
 		
 		if(qName.equals("choreography")) {
                    //System.out.println("ho finito di processare lo stato: "+states.get(0));
                    states.clear();
                    index = -1;
                    transition = null;
                    s = null;
                    //System.out.println();
                    //System.out.println("ho svutato la lista degli stati? "+states.isEmpty());
                    //System.out.println("L'automa e\' il seguente: "+fsm);
 		}
                if(qName.equals("interaction")) {
                    
                    transition = new Transition(states.get(0),states.get(index));
                }
 		
 		
  		
 	}
	
	public static void main(String[] args) throws Exception{
		
	 	//Si deve istanziare un oggetto della classe SAXParserFactory
		SAXParserFactory parserFact = SAXParserFactory.newInstance(); 
		
		//Quindi da questultimo si ottiene unistanza di parser SAX 
		SAXParser parser = parserFact.newSAXParser();
		
                String[] asf = {"test0.wscdl",
                                "test1.wscdl",
                                "test2.wscdl",
                                "test3.wscdl",
                                "test4.wscdl",
                                "test5.wscdl",
                                };
                
                File f = new File(asf[5]);
		WSCDLParser wp = new WSCDLParser();
		parser.parse(f,wp);
                PrintWriter pw = new PrintWriter(new FileOutputStream("test.txt"),true);
                pw.println(wp.getFsm().toString());
		System.out.println(wp.getFsm());
                boolean[][] am = wp.getFsm().adiacenceMatrix();
                
                
                for(int i=0; i<am.length; i++) {
                    for(int j=0; j<am[0].length; j++) {
                        System.out.println("da stato: "+i+" a stato: "+j+" "+am[i][j]);
                    }
                }
                pw.close();
                /*
                for(String nf : asf) {
		File f = new File(nf);
		WSCDLParser wp = new WSCDLParser();
		parser.parse(f,wp);
                PrintWriter pw = new PrintWriter(new FileOutputStream("test.txt"),true);
                pw.println(wp.getFsm().toString());
		System.out.print(wp.getFsm()); 
                pw.close();
                }
	}/*/
        }
}
        