/*
 * Transition.java
 *
 * Created on 23 febbraio 2007, 17.31
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.dis.uniroma1.swsce.fsm;

/**
 * This class represents a transition in a FSM.
 * @author Valerio Colaianni
 */

public class Transition {
	 
	 /**
	  * The name of the action the cause the transition
	  */
	private String action;
	
        /**
         * The endpoints of transition
         */
        private State source,target;
	
        /**
         * The condition for the transition
         */
	private String condition;
        
	/**
	 * @param action The name of the action
	 * @param source The source state of the transition
	 * @param target The target state of the transition
	 */
	public Transition(String action, State source, State target) {
		this.action = action;
                this.source = source;
                this.target = target;
                this.condition = null;
	}
	/**
         * creates an empty Transition
         */
	public Transition() {
		this.action = null;
                this.source = null;
                this.target = null;
                this.condition = null;
	}
	/**
	 * creates a Transition between the given endpoints with a null action
	 * @param source The source state of the transition
	 * @param target The target state of the transition
	 */
	public Transition(State source, State target) {
		this.action = null;
                this.source = source;
                this.target = target;
                this.condition = null;
	}
	
	//MODIFICARE IL TOSTRING PER METTERE ANCHE LA CONDIZIONE
	/**
	 * @return a representation of the transition
	 */
	@Override public String toString() {
		if(getTarget()!=null && getSource()!=null)
                    //return "Action: " + action;
                    return getSource().toString() + " -> " + getTarget().toString() + "[" + action + "]";
		else return "La transizione non e\' valida";
	}
	/**
         * @param o the reference object with which to compare. 
         * @return true if this object is the same as the o argument; false otherwise.
         */
	@Override public boolean equals(Object o) {
		if(o!=null && getClass().equals(o.getClass())) {
			Transition t = (Transition) o;
			return action.equals(t.action) && getSource().equals(t.getSource()) && getTarget().equals(t.getTarget());
		}
		return false;
	}
        /**
         * Returns a hash code value for the object. This method is supported for the benefit of hashtables such as those provided by java.util.Hashtable. 
         *@return The Hashcode of the object.
         */ 
        @Override public int hashCode() {
            int code = 17;
            if(action!=null)
                code = code*37 + this.action.hashCode();
            if(source!=null)
                code = code*37 + this.source.hashCode();
            if(target!=null)
                code = code*37 + this.target.hashCode();
            
            return code;
        }
	/**
         FARE JAVADOC PER I SET E GET DI CONDITION
         */
        public String getCondition() {
            return condition;
        }
        
        public void setCondition(String s) {
            condition = s;
        }
        
	/**
	 * @return the name of the action
	 */
	public String getAction() {
		return action;
	}
        /**
	 * @return the target state of the action
	 */
        public State getTarget() {
            return this.target;
        }
        /**
	 * @return the source state of the action
	 */
        public State getSource() {
            return this.source;
        }
        
        /**
	 * @param source the new source state of the action
	 */
        public void setSource(State source) {
            this.source = source;
        }
	
	/**
	 * @param action the new name of the action
	 */
	public void setAction(String action) {
		this.action = action;
	} 
         /**
	 * @param target the new target state of the action
	 */
        public void setTarget(State target) {
            this.target = target;
        }
	
}