/* 
 * created 16-feb-2007
 * Modified 21-feb-2007 added costructor without argoments
 * Modified 22-feb-2007 added public boolean equals(Object o)
 * DONE: OK Rivedere equals e fare le prove d'inserimento di state uguali profondamente ma diversi superficialmente
 * modified 23-feb-2007 used generics types
 * 12-jul-2007 added stateID...vedere cosa farne!
 */ 

package org.dis.uniroma1.swsce.fsm;


/**
 * This class represents a state in a FSM.
 * @author Valerio Colaianni
 */
public class State implements Comparable<State>{
	
	/**
	 * The name of the state
	 */
	private String name;
	
	/**
	 * The typology of the state: {INITIAL-FINAL,FINAL,TRANSIENT}
	 */ 
	private StateDescription description;
	
        /**
         * The id of this state, the id is used for that reasoner that represents the states with an integer value, instead of a string value
         * If it is not set, default value is -1. This value should be set by Fsm object.
         */
	private int stateID;
	
	
	/**
	 * create a new state from its name and its typology
	 * @param name The name of the state
	 * @param sd The typology of the state: {INITIAL-FINAL,FINAL,TRANSIENT}
	 */
	public State(String name, StateDescription sd) {
		this.name = name;
		this.description = sd;
		stateID = -1;
	}
	
	/**
	 * create an empty state
	 */
	public State() {
		name = null;
		description = null;
                stateID = -1;
	}
	
	public int getStateID() {
            return this.stateID;
        }

        public void setStateID(int stateID) {
            this.stateID = stateID;
        }
        
        
	/**
	 * @return a representation of the state
	 */
	@Override public String toString() {
		//return name + " ID:" + this.stateID + " " + description;
                return name + " " + description;
	}
	
        /**
         * @param o the reference object with which to compare. 
         * @return true if this object is the same as the o argument; false otherwise.
         */
	@Override public boolean equals(Object o) {
		
		if(o!=null && this.getClass().equals(o.getClass())) {
			
			State s = (State)o;
			//return this.name == s.name && this.description == s.description;
			return this.name.equalsIgnoreCase(s.name) && this.description.equals(s.description);
		}
		return false;
	}
        /**
         * Returns a hash code value for the object. This method is supported for the benefit of hashtables such as those provided by java.util.Hashtable. 
         *@return The Hashcode of the object.
         */ 
        @Override public int hashCode() {
		int code = 17;
		
                if(name!=null)
                    code = code*37 + name.hashCode();
		if(description!=null)
                    code = code*37 + description.toString().hashCode();
		
		return code;
	}
        /**
         * Compares 2 states in a alphabex order on their names
         * @return 0 iff this.equals(s), a positive integer iff this is greater than o, a negative integer otherwise
         */
        public int compareTo(State s) {
            if(this.equals(s))
                return 0;
            if(name.equals(s.name))
                return description.compareTo(s.description);
           return name.compareToIgnoreCase(s.name);
            //System.out.println("Risultato comparazione tra: "+this+" e "+s+comp);
        }
	
	/**
	 * @return the name of the state
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @param name the new name of the state
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return the typology of the state
	 */
	public StateDescription getDescription(){
		return description;
	}
	
	/**
	 * @param sd the new typology of the state
	 */
	public void setDescription(StateDescription sd) {
		description = sd;
	}

    
}